import type { MsalBrowserFlowOptions } from "./msalBrowserCommon.js";
import { MsalBrowser } from "./msalBrowserCommon.js";
import type { AccessToken } from "@azure/core-auth";
import type { AuthenticationRecord } from "../types.js";
import type { CredentialFlowGetTokenOptions } from "../credentials.js";
/**
 * Uses MSAL Browser 2.X for browser authentication,
 * which uses the [Auth Code Flow](https://learn.microsoft.com/en-us/azure/active-directory/develop/v2-oauth2-auth-code-flow).
 * @internal
 */
export declare class MSALAuthCode extends MsalBrowser {
    private loginHint?;
    /**
     * Sets up an MSAL object based on the given parameters.
     * MSAL with Auth Code allows sending a previously obtained `authenticationRecord` through the optional parameters,
     * which is set to be the active account.
     * @param options - Parameters necessary and otherwise used to create the MSAL object.
     */
    constructor(options: MsalBrowserFlowOptions);
    private getApp;
    /**
     * Loads the account based on the result of the authentication.
     * If no result was received, tries to load the account from the cache.
     * @param result - Result object received from MSAL.
     */
    private handleBrowserResult;
    /**
     * Uses MSAL to handle the redirect.
     */
    handleRedirect(): Promise<AuthenticationRecord | undefined>;
    /**
     * Uses MSAL to trigger a redirect or a popup login.
     */
    login(scopes?: string | string[]): Promise<AuthenticationRecord | undefined>;
    /**
     * Uses MSAL to retrieve the active account.
     */
    getActiveAccount(): Promise<AuthenticationRecord | undefined>;
    /**
     * Attempts to retrieve a token from cache.
     */
    getTokenSilent(scopes: string[], options?: CredentialFlowGetTokenOptions): Promise<AccessToken>;
    /**
     * Attempts to retrieve the token in the browser.
     */
    protected doGetToken(scopes: string[], options?: CredentialFlowGetTokenOptions): Promise<AccessToken>;
}
//# sourceMappingURL=msalAuthCode.d.ts.map