"use strict";
/*
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is regenerated.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.nextLink = exports.count = exports.keyRotationPolicy = exports.enc = exports.nonce = exports.targetAttestationToken = exports.signature = exports.digest = exports.algorithm2 = exports.value1 = exports.algorithm1 = exports.authenticationTag = exports.additionalAuthenticatedData = exports.iv = exports.value = exports.algorithm = exports.keyBundleBackup = exports.maxresults = exports.keyVersion = exports.releasePolicy2 = exports.tags2 = exports.keyAttributes2 = exports.keyOps1 = exports.keyName1 = exports.releasePolicy1 = exports.tags1 = exports.keyAttributes1 = exports.key = exports.hsm = exports.apiVersion = exports.keyName = exports.vaultBaseUrl = exports.releasePolicy = exports.curve = exports.tags = exports.keyAttributes = exports.keyOps = exports.publicExponent = exports.keySize = exports.kty = exports.accept = exports.contentType = void 0;
const mappers_js_1 = require("../models/mappers.js");
exports.contentType = {
    parameterPath: ["options", "contentType"],
    mapper: {
        defaultValue: "application/json",
        isConstant: true,
        serializedName: "Content-Type",
        type: {
            name: "String"
        }
    }
};
exports.accept = {
    parameterPath: "accept",
    mapper: {
        defaultValue: "application/json",
        isConstant: true,
        serializedName: "Accept",
        type: {
            name: "String"
        }
    }
};
exports.kty = {
    parameterPath: "kty",
    mapper: mappers_js_1.KeyCreateParameters
};
exports.keySize = {
    parameterPath: ["options", "keySize"],
    mapper: mappers_js_1.KeyCreateParameters
};
exports.publicExponent = {
    parameterPath: ["options", "publicExponent"],
    mapper: mappers_js_1.KeyCreateParameters
};
exports.keyOps = {
    parameterPath: ["options", "keyOps"],
    mapper: mappers_js_1.KeyCreateParameters
};
exports.keyAttributes = {
    parameterPath: ["options", "keyAttributes"],
    mapper: mappers_js_1.KeyCreateParameters
};
exports.tags = {
    parameterPath: ["options", "tags"],
    mapper: mappers_js_1.KeyCreateParameters
};
exports.curve = {
    parameterPath: ["options", "curve"],
    mapper: mappers_js_1.KeyCreateParameters
};
exports.releasePolicy = {
    parameterPath: ["options", "releasePolicy"],
    mapper: mappers_js_1.KeyCreateParameters
};
exports.vaultBaseUrl = {
    parameterPath: "vaultBaseUrl",
    mapper: {
        serializedName: "vaultBaseUrl",
        required: true,
        type: {
            name: "String"
        }
    },
    skipEncoding: true
};
exports.keyName = {
    parameterPath: "keyName",
    mapper: {
        constraints: {
            Pattern: new RegExp("^[0-9a-zA-Z-]+$")
        },
        serializedName: "key-name",
        required: true,
        type: {
            name: "String"
        }
    }
};
exports.apiVersion = {
    parameterPath: "apiVersion",
    mapper: {
        serializedName: "api-version",
        required: true,
        type: {
            name: "String"
        }
    }
};
exports.hsm = {
    parameterPath: ["options", "hsm"],
    mapper: mappers_js_1.KeyImportParameters
};
exports.key = {
    parameterPath: "key",
    mapper: mappers_js_1.KeyImportParameters
};
exports.keyAttributes1 = {
    parameterPath: ["options", "keyAttributes"],
    mapper: mappers_js_1.KeyImportParameters
};
exports.tags1 = {
    parameterPath: ["options", "tags"],
    mapper: mappers_js_1.KeyImportParameters
};
exports.releasePolicy1 = {
    parameterPath: ["options", "releasePolicy"],
    mapper: mappers_js_1.KeyImportParameters
};
exports.keyName1 = {
    parameterPath: "keyName",
    mapper: {
        serializedName: "key-name",
        required: true,
        type: {
            name: "String"
        }
    }
};
exports.keyOps1 = {
    parameterPath: ["options", "keyOps"],
    mapper: mappers_js_1.KeyUpdateParameters
};
exports.keyAttributes2 = {
    parameterPath: ["options", "keyAttributes"],
    mapper: mappers_js_1.KeyUpdateParameters
};
exports.tags2 = {
    parameterPath: ["options", "tags"],
    mapper: mappers_js_1.KeyUpdateParameters
};
exports.releasePolicy2 = {
    parameterPath: ["options", "releasePolicy"],
    mapper: mappers_js_1.KeyUpdateParameters
};
exports.keyVersion = {
    parameterPath: "keyVersion",
    mapper: {
        serializedName: "key-version",
        required: true,
        type: {
            name: "String"
        }
    }
};
exports.maxresults = {
    parameterPath: ["options", "maxresults"],
    mapper: {
        constraints: {
            InclusiveMaximum: 25,
            InclusiveMinimum: 1
        },
        serializedName: "maxresults",
        type: {
            name: "Number"
        }
    }
};
exports.keyBundleBackup = {
    parameterPath: "keyBundleBackup",
    mapper: mappers_js_1.KeyRestoreParameters
};
exports.algorithm = {
    parameterPath: "algorithm",
    mapper: mappers_js_1.KeyOperationsParameters
};
exports.value = {
    parameterPath: "value",
    mapper: mappers_js_1.KeyOperationsParameters
};
exports.iv = {
    parameterPath: ["options", "iv"],
    mapper: mappers_js_1.KeyOperationsParameters
};
exports.additionalAuthenticatedData = {
    parameterPath: ["options", "additionalAuthenticatedData"],
    mapper: mappers_js_1.KeyOperationsParameters
};
exports.authenticationTag = {
    parameterPath: ["options", "authenticationTag"],
    mapper: mappers_js_1.KeyOperationsParameters
};
exports.algorithm1 = {
    parameterPath: "algorithm",
    mapper: mappers_js_1.KeySignParameters
};
exports.value1 = {
    parameterPath: "value",
    mapper: mappers_js_1.KeySignParameters
};
exports.algorithm2 = {
    parameterPath: "algorithm",
    mapper: mappers_js_1.KeyVerifyParameters
};
exports.digest = {
    parameterPath: "digest",
    mapper: mappers_js_1.KeyVerifyParameters
};
exports.signature = {
    parameterPath: "signature",
    mapper: mappers_js_1.KeyVerifyParameters
};
exports.targetAttestationToken = {
    parameterPath: "targetAttestationToken",
    mapper: mappers_js_1.KeyReleaseParameters
};
exports.nonce = {
    parameterPath: ["options", "nonce"],
    mapper: mappers_js_1.KeyReleaseParameters
};
exports.enc = {
    parameterPath: ["options", "enc"],
    mapper: mappers_js_1.KeyReleaseParameters
};
exports.keyRotationPolicy = {
    parameterPath: "keyRotationPolicy",
    mapper: mappers_js_1.KeyRotationPolicy
};
exports.count = {
    parameterPath: "count",
    mapper: mappers_js_1.GetRandomBytesRequest
};
exports.nextLink = {
    parameterPath: "nextLink",
    mapper: {
        serializedName: "nextLink",
        required: true,
        type: {
            name: "String"
        }
    },
    skipEncoding: true
};
//# sourceMappingURL=parameters.js.map