"use strict";
// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.RecoverDeletedKeyPoller = void 0;
const operation_js_1 = require("./operation.js");
const keyVaultKeyPoller_js_1 = require("../keyVaultKeyPoller.js");
/**
 * Class that deletes a poller that waits until a key finishes being deleted
 */
class RecoverDeletedKeyPoller extends keyVaultKeyPoller_js_1.KeyVaultKeyPoller {
    constructor(options) {
        const { vaultUrl, client, name, operationOptions, intervalInMs = 2000, resumeFrom } = options;
        let state;
        if (resumeFrom) {
            state = JSON.parse(resumeFrom).state;
        }
        const operation = new operation_js_1.RecoverDeletedKeyPollOperation(Object.assign(Object.assign({}, state), { name }), vaultUrl, client, operationOptions);
        super(operation);
        this.intervalInMs = intervalInMs;
    }
}
exports.RecoverDeletedKeyPoller = RecoverDeletedKeyPoller;
//# sourceMappingURL=poller.js.map