
Object.defineProperty(exports, "__esModule", { value: true });

const {
  Decimal,
  objectEnumValues,
  makeStrictEnum,
  Public,
  getRuntime,
} = require('./runtime/index-browser.js')


const Prisma = {}

exports.Prisma = Prisma
exports.$Enums = {}

/**
 * Prisma Client JS version: 5.14.0
 * Query Engine version: e9771e62de70f79a5e1c604a2d7c8e2a0a874b48
 */
Prisma.prismaVersion = {
  client: "5.14.0",
  engine: "e9771e62de70f79a5e1c604a2d7c8e2a0a874b48"
}

Prisma.PrismaClientKnownRequestError = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`PrismaClientKnownRequestError is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)};
Prisma.PrismaClientUnknownRequestError = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`PrismaClientUnknownRequestError is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.PrismaClientRustPanicError = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`PrismaClientRustPanicError is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.PrismaClientInitializationError = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`PrismaClientInitializationError is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.PrismaClientValidationError = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`PrismaClientValidationError is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.NotFoundError = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`NotFoundError is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.Decimal = Decimal

/**
 * Re-export of sql-template-tag
 */
Prisma.sql = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`sqltag is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.empty = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`empty is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.join = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`join is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.raw = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`raw is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.validator = Public.validator

/**
* Extensions
*/
Prisma.getExtensionContext = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`Extensions.getExtensionContext is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.defineExtension = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`Extensions.defineExtension is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}

/**
 * Shorthand utilities for JSON filtering
 */
Prisma.DbNull = objectEnumValues.instances.DbNull
Prisma.JsonNull = objectEnumValues.instances.JsonNull
Prisma.AnyNull = objectEnumValues.instances.AnyNull

Prisma.NullTypes = {
  DbNull: objectEnumValues.classes.DbNull,
  JsonNull: objectEnumValues.classes.JsonNull,
  AnyNull: objectEnumValues.classes.AnyNull
}

/**
 * Enums
 */

exports.Prisma.TransactionIsolationLevel = makeStrictEnum({
  ReadUncommitted: 'ReadUncommitted',
  ReadCommitted: 'ReadCommitted',
  RepeatableRead: 'RepeatableRead',
  Serializable: 'Serializable'
});

exports.Prisma.UserScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  username: 'username',
  email: 'email',
  email_verified: 'email_verified',
  password: 'password',
  status_id: 'status_id',
  role: 'role',
  process_status: 'process_status',
  is_drafted: 'is_drafted',
  reason: 'reason',
  company_id: 'company_id',
  created_by: 'created_by',
  updated_by: 'updated_by',
  deleted_by: 'deleted_by',
  created_at: 'created_at',
  updated_at: 'updated_at',
  deleted_at: 'deleted_at',
  last_login: 'last_login',
  last_login_device: 'last_login_device'
};

exports.Prisma.UserDetailScalarFieldEnum = {
  id: 'id',
  user_id: 'user_id',
  code: 'code',
  first_name: 'first_name',
  last_name: 'last_name',
  designation_id: 'designation_id',
  department_id: 'department_id',
  organization_id: 'organization_id',
  profile_pic: 'profile_pic',
  dob: 'dob',
  country_code: 'country_code',
  phone_number: 'phone_number',
  gender: 'gender',
  user_time_zone: 'user_time_zone',
  address: 'address',
  culture: 'culture',
  company_id: 'company_id',
  created_by: 'created_by',
  updated_by: 'updated_by',
  deleted_by: 'deleted_by',
  created_at: 'created_at',
  updated_at: 'updated_at',
  deleted_at: 'deleted_at'
};

exports.Prisma.DesignationScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  code: 'code',
  name: 'name',
  description: 'description',
  status_id: 'status_id',
  company_id: 'company_id',
  created_by: 'created_by',
  updated_by: 'updated_by',
  deleted_by: 'deleted_by',
  created_at: 'created_at',
  updated_at: 'updated_at',
  deleted_at: 'deleted_at'
};

exports.Prisma.DepartmentScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  code: 'code',
  name: 'name',
  description: 'description',
  status_id: 'status_id',
  department_head_id: 'department_head_id',
  company_id: 'company_id',
  created_by: 'created_by',
  updated_by: 'updated_by',
  deleted_by: 'deleted_by',
  created_at: 'created_at',
  updated_at: 'updated_at',
  deleted_at: 'deleted_at'
};

exports.Prisma.RequestLogScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  user_id: 'user_id',
  req_method: 'req_method',
  req_url: 'req_url',
  req_body: 'req_body',
  res_status: 'res_status',
  res_code: 'res_code',
  res_message: 'res_message',
  req_response: 'req_response',
  req_headers: 'req_headers',
  req_ip: 'req_ip',
  req_device: 'req_device',
  status_id: 'status_id',
  company_id: 'company_id',
  created_at: 'created_at',
  updated_at: 'updated_at',
  deleted_at: 'deleted_at'
};

exports.Prisma.FinancialYearScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  name: 'name',
  code: 'code',
  is_freezed: 'is_freezed',
  start_date: 'start_date',
  end_date: 'end_date',
  status_id: 'status_id',
  company_id: 'company_id',
  created_by: 'created_by',
  updated_by: 'updated_by',
  deleted_by: 'deleted_by',
  created_at: 'created_at',
  updated_at: 'updated_at',
  deleted_at: 'deleted_at'
};

exports.Prisma.DocumentSequenceScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  module_name: 'module_name',
  financial_year_id: 'financial_year_id',
  current_sequence_no: 'current_sequence_no',
  start_sequence_no: 'start_sequence_no',
  end_sequence_no: 'end_sequence_no',
  sequence_length: 'sequence_length',
  status_id: 'status_id',
  code_format: 'code_format',
  company_id: 'company_id',
  created_by: 'created_by',
  updated_by: 'updated_by',
  deleted_by: 'deleted_by',
  created_at: 'created_at',
  updated_at: 'updated_at',
  deleted_at: 'deleted_at'
};

exports.Prisma.AuditLogScalarFieldEnum = {
  id: 'id',
  operation_type: 'operation_type',
  table_name: 'table_name',
  field_name: 'field_name',
  old_value: 'old_value',
  new_value: 'new_value',
  entity_id: 'entity_id',
  user_id: 'user_id',
  status_id: 'status_id',
  company_id: 'company_id',
  created_at: 'created_at'
};

exports.Prisma.PermissionsScalarFieldEnum = {
  id: 'id',
  name: 'name',
  slug: 'slug',
  entity_id: 'entity_id',
  order_no: 'order_no',
  status_id: 'status_id',
  company_id: 'company_id',
  created_at: 'created_at'
};

exports.Prisma.RoleScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  name: 'name',
  description: 'description',
  status_id: 'status_id',
  company_id: 'company_id',
  created_by: 'created_by',
  updated_by: 'updated_by',
  deleted_by: 'deleted_by',
  created_at: 'created_at',
  updated_at: 'updated_at',
  deleted_at: 'deleted_at'
};

exports.Prisma.RolePermissionsScalarFieldEnum = {
  role_id: 'role_id',
  permission_id: 'permission_id',
  company_id: 'company_id'
};

exports.Prisma.UserRolesScalarFieldEnum = {
  user_id: 'user_id',
  role_id: 'role_id',
  company_id: 'company_id'
};

exports.Prisma.UserPermissionsScalarFieldEnum = {
  user_id: 'user_id',
  permission_id: 'permission_id',
  company_id: 'company_id'
};

exports.Prisma.OtpScalarFieldEnum = {
  id: 'id',
  user_id: 'user_id',
  otp: 'otp',
  purpose: 'purpose',
  company_id: 'company_id',
  created_at: 'created_at'
};

exports.Prisma.LanguageScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  name: 'name',
  name_in_english: 'name_in_english',
  flag: 'flag',
  code: 'code',
  rtl: 'rtl',
  description: 'description',
  status_id: 'status_id',
  company_id: 'company_id',
  created_by: 'created_by',
  updated_by: 'updated_by',
  deleted_by: 'deleted_by',
  created_at: 'created_at',
  updated_at: 'updated_at',
  deleted_at: 'deleted_at'
};

exports.Prisma.LanguageContentScalarFieldEnum = {
  id: 'id',
  language_id: 'language_id',
  key_content: 'key_content',
  values: 'values',
  status_id: 'status_id',
  company_id: 'company_id',
  created_at: 'created_at'
};

exports.Prisma.MenusScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  name: 'name',
  slug: 'slug',
  description: 'description',
  menu_type: 'menu_type',
  status_id: 'status_id',
  company_id: 'company_id',
  created_by: 'created_by',
  updated_by: 'updated_by',
  deleted_by: 'deleted_by',
  created_at: 'created_at',
  updated_at: 'updated_at',
  deleted_at: 'deleted_at'
};

exports.Prisma.MenuItemsScalarFieldEnum = {
  id: 'id',
  menu_id: 'menu_id',
  name: 'name',
  target: 'target',
  parent_id: 'parent_id',
  permission_id: 'permission_id',
  entity_id: 'entity_id',
  link_type: 'link_type',
  order_no: 'order_no',
  menu_img: 'menu_img',
  short_cut_keys: 'short_cut_keys',
  status_id: 'status_id',
  company_id: 'company_id',
  created_by: 'created_by',
  updated_by: 'updated_by',
  deleted_by: 'deleted_by',
  created_at: 'created_at',
  updated_at: 'updated_at',
  deleted_at: 'deleted_at'
};

exports.Prisma.ActionTypeScalarFieldEnum = {
  id: 'id',
  name: 'name',
  description: 'description',
  company_id: 'company_id'
};

exports.Prisma.EntityTypeScalarFieldEnum = {
  id: 'id',
  name: 'name',
  slug: 'slug',
  description: 'description',
  company_id: 'company_id'
};

exports.Prisma.WizardGroupScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  name: 'name',
  slug: 'slug',
  description: 'description',
  status_id: 'status_id',
  created_at: 'created_at',
  company_id: 'company_id'
};

exports.Prisma.WizardTypeScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  name: 'name',
  description: 'description',
  company_id: 'company_id'
};

exports.Prisma.AboutLCPScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  type: 'type',
  name: 'name',
  description: 'description',
  order_no: 'order_no',
  documentation_video_url: 'documentation_video_url',
  documentation_pdf: 'documentation_pdf',
  documentation_word: 'documentation_word',
  status_id: 'status_id',
  company_id: 'company_id',
  created_by: 'created_by',
  created_at: 'created_at',
  updated_by: 'updated_by',
  updated_at: 'updated_at',
  deleted_by: 'deleted_by',
  deleted_at: 'deleted_at'
};

exports.Prisma.MasterEntityScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  name: 'name',
  entity_name: 'entity_name',
  entity_type: 'entity_type',
  report_type: 'report_type',
  primary_table: 'primary_table',
  is_admin_module: 'is_admin_module',
  draft_mode: 'draft_mode',
  associated_tables: 'associated_tables',
  query_information: 'query_information',
  form_information: 'form_information',
  report_information: 'report_information',
  add_query_information: 'add_query_information',
  edit_query_information: 'edit_query_information',
  preset_query_information: 'preset_query_information',
  static_page_content: 'static_page_content',
  export_template_id: 'export_template_id',
  dashboard_wizard_group_id: 'dashboard_wizard_group_id',
  dashboard_wizard_type: 'dashboard_wizard_type',
  dashboard_wizard_rows: 'dashboard_wizard_rows',
  dashboard_wizard_columns: 'dashboard_wizard_columns',
  dashboard_wizard_order_no: 'dashboard_wizard_order_no',
  dashboard_wizard_options: 'dashboard_wizard_options',
  status_id: 'status_id',
  company_id: 'company_id',
  created_at: 'created_at',
  deleted_at: 'deleted_at'
};

exports.Prisma.MasterEntityLineItemScalarFieldEnum = {
  id: 'id',
  master_grid_id: 'master_grid_id',
  field_name: 'field_name',
  display_name: 'display_name',
  order_no: 'order_no',
  is_grid_column: 'is_grid_column',
  is_searchable: 'is_searchable',
  clause_type: 'clause_type',
  is_sortable: 'is_sortable',
  field_type_id: 'field_type_id',
  link_type: 'link_type',
  link_action: 'link_action',
  link_mode: 'link_mode',
  status_id: 'status_id',
  company_id: 'company_id',
  created_at: 'created_at'
};

exports.Prisma.FieldTypeScalarFieldEnum = {
  id: 'id',
  field_type: 'field_type',
  company_id: 'company_id',
  status_id: 'status_id',
  created_at: 'created_at'
};

exports.Prisma.MenuTypeScalarFieldEnum = {
  id: 'id',
  name: 'name',
  status_id: 'status_id',
  company_id: 'company_id',
  created_at: 'created_at'
};

exports.Prisma.EmailTemplateProcessScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  name: 'name',
  slug: 'slug',
  query_information: 'query_information',
  status_id: 'status_id',
  company_id: 'company_id'
};

exports.Prisma.EmailTemplateTagScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  slug: 'slug',
  name: 'name',
  description: 'description',
  status_id: 'status_id',
  company_id: 'company_id'
};

exports.Prisma.EmailTemplateRecipientTagScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  slug: 'slug',
  name: 'name',
  description: 'description',
  query_information: 'query_information',
  status_id: 'status_id',
  company_id: 'company_id'
};

exports.Prisma.EmailTemplateProcessTagsMappingScalarFieldEnum = {
  email_template_process_id: 'email_template_process_id',
  email_template_tag_id: 'email_template_tag_id',
  company_id: 'company_id'
};

exports.Prisma.EmailTemplateScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  slug: 'slug',
  name: 'name',
  subject: 'subject',
  template_body: 'template_body',
  email_template_process_id: 'email_template_process_id',
  status_id: 'status_id',
  created_at: 'created_at',
  created_by: 'created_by',
  updated_at: 'updated_at',
  updated_by: 'updated_by',
  deleted_at: 'deleted_at',
  deleted_by: 'deleted_by',
  company_id: 'company_id'
};

exports.Prisma.EmailTemplateAssignmentScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  email_template_process_id: 'email_template_process_id',
  template_id: 'template_id',
  recipient_type: 'recipient_type',
  email_to: 'email_to',
  company_id: 'company_id',
  created_at: 'created_at',
  created_by: 'created_by'
};

exports.Prisma.EmailTemplateCcBccScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  send_type: 'send_type',
  recipient_type: 'recipient_type',
  email_to: 'email_to',
  company_id: 'company_id',
  created_at: 'created_at',
  created_by: 'created_by',
  email_template_assignment_id: 'email_template_assignment_id'
};

exports.Prisma.EmailProcessJobScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  email_template_process_slug: 'email_template_process_slug',
  unique_id: 'unique_id',
  user_id: 'user_id',
  prefill_data: 'prefill_data',
  attachments_path: 'attachments_path',
  attachments_name: 'attachments_name',
  company_id: 'company_id',
  status_id: 'status_id',
  created_at: 'created_at',
  created_by: 'created_by'
};

exports.Prisma.WhatsappProcessJobScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  whatsapp_template_process_slug: 'whatsapp_template_process_slug',
  unique_id: 'unique_id',
  user_id: 'user_id',
  prefill_data: 'prefill_data',
  attachments_path: 'attachments_path',
  attachments_name: 'attachments_name',
  company_id: 'company_id',
  status_id: 'status_id',
  created_at: 'created_at',
  created_by: 'created_by'
};

exports.Prisma.WhatsappTemplateProcessScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  name: 'name',
  slug: 'slug',
  query_information: 'query_information',
  status_id: 'status_id',
  company_id: 'company_id'
};

exports.Prisma.WhatsappTemplateTagScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  slug: 'slug',
  name: 'name',
  description: 'description',
  status_id: 'status_id',
  company_id: 'company_id'
};

exports.Prisma.WhatsappTemplateRecipientTagScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  slug: 'slug',
  name: 'name',
  description: 'description',
  query_information: 'query_information',
  status_id: 'status_id',
  company_id: 'company_id'
};

exports.Prisma.WhatsappTemplateProcessTagsMappingScalarFieldEnum = {
  whatsapp_template_process_id: 'whatsapp_template_process_id',
  whatsapp_template_tag_id: 'whatsapp_template_tag_id',
  company_id: 'company_id'
};

exports.Prisma.WhatsappTemplateScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  slug: 'slug',
  name: 'name',
  message: 'message',
  whatsapp_template_process_id: 'whatsapp_template_process_id',
  status_id: 'status_id',
  created_at: 'created_at',
  created_by: 'created_by',
  updated_at: 'updated_at',
  updated_by: 'updated_by',
  deleted_at: 'deleted_at',
  deleted_by: 'deleted_by',
  company_id: 'company_id'
};

exports.Prisma.WhatsappTemplateAssignmentScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  whatsapp_template_process_id: 'whatsapp_template_process_id',
  template_id: 'template_id',
  recipient_type: 'recipient_type',
  whatsapp_to: 'whatsapp_to',
  company_id: 'company_id',
  created_at: 'created_at',
  created_by: 'created_by'
};

exports.Prisma.NotificationJobScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  process_slug: 'process_slug',
  notification_to: 'notification_to',
  notification_subject: 'notification_subject',
  notification_content: 'notification_content',
  attachments_path: 'attachments_path',
  attachments_name: 'attachments_name',
  notification_cc: 'notification_cc',
  notification_bcc: 'notification_bcc',
  notification_type_id: 'notification_type_id',
  notification_status_id: 'notification_status_id',
  notification_type: 'notification_type',
  company_id: 'company_id',
  status_id: 'status_id',
  parent_id: 'parent_id',
  no_of_attempts: 'no_of_attempts',
  created_at: 'created_at',
  created_by: 'created_by',
  sent_at: 'sent_at',
  read_at: 'read_at'
};

exports.Prisma.CarouselTemplateScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  name: 'name',
  slug: 'slug',
  description: 'description',
  status_id: 'status_id',
  company_id: 'company_id',
  created_by: 'created_by',
  created_at: 'created_at',
  updated_by: 'updated_by',
  updated_at: 'updated_at',
  deleted_by: 'deleted_by',
  deleted_at: 'deleted_at'
};

exports.Prisma.CarouselTemplateLineItemScalarFieldEnum = {
  id: 'id',
  carousel_template_id: 'carousel_template_id',
  name: 'name',
  slug: 'slug',
  description: 'description',
  image_url: 'image_url',
  video_url: 'video_url',
  clickable_link: 'clickable_link',
  order_no: 'order_no',
  status_id: 'status_id',
  company_id: 'company_id',
  created_at: 'created_at'
};

exports.Prisma.ImportTemplateScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  name: 'name',
  slug: 'slug',
  description: 'description',
  max_row_count: 'max_row_count',
  header_row: 'header_row',
  data_start_row: 'data_start_row',
  data_end_row: 'data_end_row',
  ignore_error_rows: 'ignore_error_rows',
  is_admin_module: 'is_admin_module',
  is_send_mail: 'is_send_mail',
  email_process_slug: 'email_process_slug',
  job_type: 'job_type',
  batch_process_count: 'batch_process_count',
  status_id: 'status_id',
  company_id: 'company_id',
  created_by: 'created_by',
  created_at: 'created_at',
  updated_by: 'updated_by',
  updated_at: 'updated_at',
  deleted_by: 'deleted_by',
  deleted_at: 'deleted_at'
};

exports.Prisma.ImportTemplateLineItemScalarFieldEnum = {
  id: 'id',
  import_template_id: 'import_template_id',
  field_name: 'field_name',
  display_name: 'display_name',
  field_table: 'field_table',
  order_no: 'order_no',
  width: 'width',
  default_value: 'default_value',
  check_reg_exp: 'check_reg_exp',
  is_nullable: 'is_nullable',
  is_unique: 'is_unique',
  is_foreign: 'is_foreign',
  unique_query: 'unique_query',
  foreign_query: 'foreign_query',
  is_enum: 'is_enum',
  is_multiple: 'is_multiple',
  enum_values: 'enum_values',
  expression_rules: 'expression_rules',
  foreign_table: 'foreign_table',
  foreign_column: 'foreign_column',
  foreign_can_create: 'foreign_can_create',
  is_individual: 'is_individual',
  individual_column: 'individual_column',
  field_type_id: 'field_type_id',
  status_id: 'status_id',
  company_id: 'company_id',
  created_at: 'created_at'
};

exports.Prisma.ImportTemplateQueriesScalarFieldEnum = {
  id: 'id',
  import_template_id: 'import_template_id',
  query_string: 'query_string',
  query_name: 'query_name',
  allow_multiple: 'allow_multiple',
  is_individual: 'is_individual',
  before_lineitems: 'before_lineitems',
  order_no: 'order_no',
  status_id: 'status_id',
  company_id: 'company_id',
  created_at: 'created_at'
};

exports.Prisma.ImportJobScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  name: 'name',
  description: 'description',
  sequence_number: 'sequence_number',
  header_details: 'header_details',
  table_config: 'table_config',
  total_rows: 'total_rows',
  completed_rows: 'completed_rows',
  error_rows: 'error_rows',
  batch_process_count: 'batch_process_count',
  job_status: 'job_status',
  last_processed_row_id: 'last_processed_row_id',
  file_path: 'file_path',
  file_name: 'file_name',
  status_id: 'status_id',
  company_id: 'company_id',
  created_by: 'created_by',
  created_at: 'created_at',
  updated_by: 'updated_by',
  updated_at: 'updated_at',
  deleted_by: 'deleted_by',
  deleted_at: 'deleted_at'
};

exports.Prisma.ImportJobLineItemScalarFieldEnum = {
  id: 'id',
  import_job_id: 'import_job_id',
  row_object: 'row_object',
  job_status: 'job_status',
  status_id: 'status_id',
  company_id: 'company_id',
  created_at: 'created_at'
};

exports.Prisma.ExportTemplateScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  name: 'name',
  slug: 'slug',
  description: 'description',
  max_row_count: 'max_row_count',
  header_row: 'header_row',
  data_start_row: 'data_start_row',
  data_end_row: 'data_end_row',
  data_filepath: 'data_filepath',
  status_id: 'status_id',
  company_id: 'company_id',
  created_by: 'created_by',
  created_at: 'created_at',
  updated_by: 'updated_by',
  updated_at: 'updated_at',
  deleted_by: 'deleted_by',
  deleted_at: 'deleted_at'
};

exports.Prisma.ExportTemplateLineItemScalarFieldEnum = {
  id: 'id',
  export_template_id: 'export_template_id',
  field_name: 'field_name',
  display_name: 'display_name',
  field_table: 'field_table',
  order_no: 'order_no',
  default_value: 'default_value',
  column_name: 'column_name',
  is_individual: 'is_individual',
  individual_column: 'individual_column',
  field_type_id: 'field_type_id',
  status_id: 'status_id',
  company_id: 'company_id',
  created_at: 'created_at'
};

exports.Prisma.ExportTemplateQueriesScalarFieldEnum = {
  id: 'id',
  export_template_id: 'export_template_id',
  query_string: 'query_string',
  query_name: 'query_name',
  query_procedure: 'query_procedure',
  is_individual: 'is_individual',
  order_no: 'order_no',
  status_id: 'status_id',
  company_id: 'company_id',
  created_at: 'created_at'
};

exports.Prisma.StatusScalarFieldEnum = {
  id: 'id',
  name: 'name',
  slug: 'slug',
  description: 'description',
  status_id: 'status_id'
};

exports.Prisma.CategoryTypesScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  category_type_id: 'category_type_id',
  name: 'name',
  description: 'description',
  company_id: 'company_id',
  created_by: 'created_by',
  updated_by: 'updated_by',
  deleted_by: 'deleted_by',
  created_at: 'created_at',
  updated_at: 'updated_at',
  deleted_at: 'deleted_at'
};

exports.Prisma.CategoriesScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  category_type_id: 'category_type_id',
  category_id: 'category_id',
  parent_id: 'parent_id',
  name: 'name',
  description: 'description',
  status_id: 'status_id',
  company_id: 'company_id',
  created_by: 'created_by',
  updated_by: 'updated_by',
  deleted_by: 'deleted_by',
  created_at: 'created_at',
  updated_at: 'updated_at',
  deleted_at: 'deleted_at'
};

exports.Prisma.ConfigurationsScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  order_no: 'order_no',
  config_key: 'config_key',
  category_id: 'category_id',
  config_value: 'config_value',
  config_select_json: 'config_select_json',
  config_file_value: 'config_file_value',
  config_value_type: 'config_value_type',
  config_field_type: 'config_field_type',
  display_config: 'display_config',
  company_id: 'company_id',
  created_by: 'created_by',
  updated_by: 'updated_by',
  deleted_by: 'deleted_by',
  created_at: 'created_at',
  updated_at: 'updated_at',
  deleted_at: 'deleted_at'
};

exports.Prisma.UserConfigurationsScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  order_no: 'order_no',
  config_key: 'config_key',
  category_id: 'category_id',
  config_value: 'config_value',
  config_select_json: 'config_select_json',
  config_file_value: 'config_file_value',
  config_value_type: 'config_value_type',
  config_field_type: 'config_field_type',
  display_config: 'display_config',
  user_id: 'user_id',
  company_id: 'company_id',
  created_by: 'created_by',
  updated_by: 'updated_by',
  deleted_by: 'deleted_by',
  created_at: 'created_at',
  updated_at: 'updated_at',
  deleted_at: 'deleted_at'
};

exports.Prisma.FileUploadLogScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  doc_name: 'doc_name',
  org_name: 'org_name',
  extension: 'extension',
  description: 'description',
  status_id: 'status_id',
  company_id: 'company_id',
  created_at: 'created_at'
};

exports.Prisma.DataTransferQueriesScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  select_query: 'select_query',
  insert_query: 'insert_query',
  transfer_type: 'transfer_type',
  job_name: 'job_name',
  destination_table: 'destination_table',
  clear_destination_table: 'clear_destination_table',
  execution_order: 'execution_order',
  command_type: 'command_type',
  status_id: 'status_id',
  created_by: 'created_by',
  created_at: 'created_at',
  company_id: 'company_id'
};

exports.Prisma.DeviceRegistrationScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  company_id: 'company_id',
  device_name: 'device_name',
  device_unique_id: 'device_unique_id',
  user_id: 'user_id',
  status_id: 'status_id',
  created_by: 'created_by',
  created_at: 'created_at',
  updated_by: 'updated_by',
  updated_at: 'updated_at',
  deleted_by: 'deleted_by',
  deleted_at: 'deleted_at'
};

exports.Prisma.PoliciesScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  company_id: 'company_id',
  slug: 'slug',
  name: 'name',
  description: 'description',
  query_information: 'query_information',
  status_id: 'status_id',
  created_by: 'created_by',
  created_at: 'created_at',
  updated_by: 'updated_by',
  updated_at: 'updated_at',
  deleted_by: 'deleted_by',
  deleted_at: 'deleted_at'
};

exports.Prisma.UserPoliciesScalarFieldEnum = {
  company_id: 'company_id',
  policy_id: 'policy_id',
  user_id: 'user_id'
};

exports.Prisma.RolePoliciesScalarFieldEnum = {
  company_id: 'company_id',
  policy_id: 'policy_id',
  role_id: 'role_id'
};

exports.Prisma.AppversionsScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  company_id: 'company_id',
  type: 'type',
  version_type: 'version_type',
  version: 'version',
  description: 'description',
  is_frontend_changed: 'is_frontend_changed',
  is_backend_changed: 'is_backend_changed',
  is_database_changed: 'is_database_changed',
  developed_by: 'developed_by',
  status_id: 'status_id',
  created_by: 'created_by',
  created_at: 'created_at',
  updated_by: 'updated_by',
  updated_at: 'updated_at',
  deleted_by: 'deleted_by',
  deleted_at: 'deleted_at'
};

exports.Prisma.ScheduledJobScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  timing: 'timing',
  cron_url: 'cron_url',
  concat_base_url: 'concat_base_url',
  description: 'description',
  created_at: 'created_at',
  company_id: 'company_id',
  status_id: 'status_id'
};

exports.Prisma.ScheduledJobLogsScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  scheduled_job_id: 'scheduled_job_id',
  executed_statement: 'executed_statement',
  schedule_status: 'schedule_status',
  response: 'response',
  created_at: 'created_at',
  company_id: 'company_id',
  status_id: 'status_id'
};

exports.Prisma.ApprovalWorkflowScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  name: 'name',
  description: 'description',
  slug: 'slug',
  query_information: 'query_information',
  status_id: 'status_id',
  url: 'url',
  company_id: 'company_id',
  created_by: 'created_by',
  created_at: 'created_at',
  updated_by: 'updated_by',
  updated_at: 'updated_at',
  deleted_by: 'deleted_by',
  deleted_at: 'deleted_at'
};

exports.Prisma.ApprovalWorkflowApproverTagScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  slug: 'slug',
  name: 'name',
  description: 'description',
  query_information: 'query_information',
  status_id: 'status_id',
  company_id: 'company_id',
  created_by: 'created_by',
  created_at: 'created_at',
  updated_by: 'updated_by',
  updated_at: 'updated_at',
  deleted_by: 'deleted_by',
  deleted_at: 'deleted_at'
};

exports.Prisma.ApprovalWorkflowAssignmentScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  approval_workflow_id: 'approval_workflow_id',
  approver_order_no: 'approver_order_no',
  approver_type: 'approver_type',
  approver: 'approver',
  approve_query_information: 'approve_query_information',
  reject_query_information: 'reject_query_information',
  status_id: 'status_id',
  company_id: 'company_id',
  created_by: 'created_by',
  created_at: 'created_at',
  updated_by: 'updated_by',
  updated_at: 'updated_at',
  deleted_by: 'deleted_by',
  deleted_at: 'deleted_at',
  approve_mail_id: 'approve_mail_id',
  reject_mail_id: 'reject_mail_id',
  approve_whatsapp_id: 'approve_whatsapp_id',
  reject_whatsapp_id: 'reject_whatsapp_id'
};

exports.Prisma.ApprovalProcessJobScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  approval_workflow_slug: 'approval_workflow_slug',
  sequence_no: 'sequence_no',
  description: 'description',
  primary_table: 'primary_table',
  unique_id: 'unique_id',
  screen_id: 'screen_id',
  user_id: 'user_id',
  prefill_data: 'prefill_data',
  details: 'details',
  status_id: 'status_id',
  company_id: 'company_id'
};

exports.Prisma.ApprovalProcessJobWorkflowScalarFieldEnum = {
  id: 'id',
  approval_workflow_assignment_id: 'approval_workflow_assignment_id',
  approval_process_job_id: 'approval_process_job_id',
  approval_workflow_slug: 'approval_workflow_slug',
  approval_process_job_name: 'approval_process_job_name',
  approval_process_job_description: 'approval_process_job_description',
  approve_query_information: 'approve_query_information',
  reject_query_information: 'reject_query_information',
  primary_table: 'primary_table',
  sequence_no: 'sequence_no',
  unique_id: 'unique_id',
  user_id: 'user_id',
  screen_id: 'screen_id',
  prefill_data: 'prefill_data',
  url: 'url',
  approver_order_no: 'approver_order_no',
  approver_type: 'approver_type',
  approver: 'approver',
  review_status: 'review_status',
  status_id: 'status_id',
  reviewed_by: 'reviewed_by',
  reason: 'reason',
  approve_mail_id: 'approve_mail_id',
  reject_mail_id: 'reject_mail_id',
  approve_whatsapp_id: 'approve_whatsapp_id',
  reject_whatsapp_id: 'reject_whatsapp_id',
  company_id: 'company_id',
  created_at: 'created_at',
  assigned_at: 'assigned_at',
  processed_at: 'processed_at',
  deleted_by: 'deleted_by',
  deleted_at: 'deleted_at',
  details: 'details'
};

exports.Prisma.ApprovalProcessJobWorkflowUserScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  approval_process_job_workflow_id: 'approval_process_job_workflow_id',
  user_id: 'user_id',
  status_id: 'status_id',
  company_id: 'company_id'
};

exports.Prisma.DelegationScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  user_id: 'user_id',
  delegated_user_id: 'delegated_user_id',
  reason: 'reason',
  start_date: 'start_date',
  end_date: 'end_date',
  status_id: 'status_id',
  company_id: 'company_id',
  created_by: 'created_by',
  created_at: 'created_at',
  updated_by: 'updated_by',
  updated_at: 'updated_at',
  deleted_by: 'deleted_by',
  deleted_at: 'deleted_at'
};

exports.Prisma.SchemaChunkScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  table_name: 'table_name',
  chunk: 'chunk',
  status_id: 'status_id',
  created_at: 'created_at',
  created_by: 'created_by',
  updated_by: 'updated_by',
  updated_at: 'updated_at',
  deleted_by: 'deleted_by',
  deleted_at: 'deleted_at',
  company_id: 'company_id'
};

exports.Prisma.EmbeddingVectorLogsScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  user_id: 'user_id',
  cost: 'cost',
  company_id: 'company_id',
  table_name: 'table_name',
  status_id: 'status_id',
  created_at: 'created_at',
  created_by: 'created_by',
  updated_by: 'updated_by',
  updated_at: 'updated_at',
  deleted_by: 'deleted_by',
  deleted_at: 'deleted_at'
};

exports.Prisma.OpenaiUsageLogScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  user_id: 'user_id',
  prompt: 'prompt',
  generated_sql: 'generated_sql',
  prompt_tokens: 'prompt_tokens',
  completion_tokens: 'completion_tokens',
  total_tokens: 'total_tokens',
  cost: 'cost',
  status_id: 'status_id',
  company_id: 'company_id',
  created_at: 'created_at',
  created_by: 'created_by',
  updated_by: 'updated_by',
  updated_at: 'updated_at',
  deleted_by: 'deleted_by',
  deleted_at: 'deleted_at'
};

exports.Prisma.QueryExecutionLogScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  company_id: 'company_id',
  status_id: 'status_id',
  query: 'query',
  created_at: 'created_at',
  created_by: 'created_by',
  updated_by: 'updated_by',
  updated_at: 'updated_at',
  deleted_by: 'deleted_by',
  deleted_at: 'deleted_at'
};

exports.Prisma.ChildProcessScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  name: 'name',
  slug: 'slug',
  description: 'description',
  command: 'command',
  status_id: 'status_id',
  company_id: 'company_id',
  created_by: 'created_by',
  created_at: 'created_at',
  updated_by: 'updated_by',
  updated_at: 'updated_at',
  deleted_by: 'deleted_by',
  deleted_at: 'deleted_at'
};

exports.Prisma.ChildProcessLogScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  child_process_id: 'child_process_id',
  process_status: 'process_status',
  output: 'output',
  initiated_by: 'initiated_by',
  status_id: 'status_id',
  company_id: 'company_id',
  created_by: 'created_by',
  created_at: 'created_at',
  updated_by: 'updated_by',
  updated_at: 'updated_at',
  deleted_by: 'deleted_by',
  deleted_at: 'deleted_at'
};

exports.Prisma.OrganizationsScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  company_id: 'company_id',
  name: 'name',
  code: 'code',
  description: 'description',
  no_of_devices: 'no_of_devices',
  status_id: 'status_id',
  created_by: 'created_by',
  updated_by: 'updated_by',
  deleted_by: 'deleted_by',
  created_at: 'created_at',
  updated_at: 'updated_at',
  deleted_at: 'deleted_at'
};

exports.Prisma.SortOrder = {
  asc: 'asc',
  desc: 'desc'
};

exports.Prisma.NullableJsonNullValueInput = {
  DbNull: Prisma.DbNull,
  JsonNull: Prisma.JsonNull
};

exports.Prisma.QueryMode = {
  default: 'default',
  insensitive: 'insensitive'
};

exports.Prisma.NullsOrder = {
  first: 'first',
  last: 'last'
};

exports.Prisma.UserOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  username: 'username',
  email: 'email',
  password: 'password',
  reason: 'reason',
  last_login_device: 'last_login_device'
};

exports.Prisma.UserDetailOrderByRelevanceFieldEnum = {
  code: 'code',
  first_name: 'first_name',
  last_name: 'last_name',
  profile_pic: 'profile_pic',
  country_code: 'country_code',
  phone_number: 'phone_number',
  user_time_zone: 'user_time_zone',
  address: 'address',
  culture: 'culture'
};

exports.Prisma.DesignationOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  code: 'code',
  name: 'name',
  description: 'description'
};

exports.Prisma.DepartmentOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  code: 'code',
  name: 'name',
  description: 'description'
};

exports.Prisma.RequestLogOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  req_method: 'req_method',
  req_url: 'req_url',
  req_body: 'req_body',
  res_message: 'res_message',
  req_response: 'req_response',
  req_headers: 'req_headers',
  req_ip: 'req_ip',
  req_device: 'req_device'
};

exports.Prisma.FinancialYearOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  name: 'name',
  code: 'code'
};

exports.Prisma.DocumentSequenceOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  module_name: 'module_name',
  code_format: 'code_format'
};

exports.Prisma.AuditLogOrderByRelevanceFieldEnum = {
  operation_type: 'operation_type',
  table_name: 'table_name',
  field_name: 'field_name',
  old_value: 'old_value',
  new_value: 'new_value'
};

exports.Prisma.PermissionsOrderByRelevanceFieldEnum = {
  name: 'name',
  slug: 'slug'
};

exports.Prisma.RoleOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  name: 'name',
  description: 'description'
};

exports.Prisma.OtpOrderByRelevanceFieldEnum = {
  otp: 'otp'
};

exports.Prisma.LanguageOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  name: 'name',
  name_in_english: 'name_in_english',
  flag: 'flag',
  code: 'code',
  description: 'description'
};

exports.Prisma.LanguageContentOrderByRelevanceFieldEnum = {
  key_content: 'key_content',
  values: 'values'
};

exports.Prisma.MenusOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  name: 'name',
  slug: 'slug',
  description: 'description'
};

exports.Prisma.MenuItemsOrderByRelevanceFieldEnum = {
  name: 'name',
  target: 'target',
  menu_img: 'menu_img',
  short_cut_keys: 'short_cut_keys'
};

exports.Prisma.ActionTypeOrderByRelevanceFieldEnum = {
  name: 'name',
  description: 'description'
};

exports.Prisma.EntityTypeOrderByRelevanceFieldEnum = {
  name: 'name',
  slug: 'slug',
  description: 'description'
};

exports.Prisma.WizardGroupOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  name: 'name',
  slug: 'slug',
  description: 'description'
};

exports.Prisma.WizardTypeOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  name: 'name',
  description: 'description'
};

exports.Prisma.AboutLCPOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  name: 'name',
  description: 'description',
  documentation_video_url: 'documentation_video_url',
  documentation_pdf: 'documentation_pdf',
  documentation_word: 'documentation_word'
};

exports.Prisma.JsonNullValueFilter = {
  DbNull: Prisma.DbNull,
  JsonNull: Prisma.JsonNull,
  AnyNull: Prisma.AnyNull
};

exports.Prisma.MasterEntityOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  name: 'name',
  entity_name: 'entity_name',
  entity_type: 'entity_type',
  primary_table: 'primary_table',
  static_page_content: 'static_page_content',
  dashboard_wizard_type: 'dashboard_wizard_type'
};

exports.Prisma.MasterEntityLineItemOrderByRelevanceFieldEnum = {
  field_name: 'field_name',
  display_name: 'display_name',
  link_type: 'link_type',
  link_action: 'link_action',
  link_mode: 'link_mode'
};

exports.Prisma.FieldTypeOrderByRelevanceFieldEnum = {
  field_type: 'field_type'
};

exports.Prisma.menuTypeOrderByRelevanceFieldEnum = {
  name: 'name'
};

exports.Prisma.EmailTemplateProcessOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  name: 'name',
  slug: 'slug',
  query_information: 'query_information'
};

exports.Prisma.EmailTemplateTagOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  slug: 'slug',
  name: 'name',
  description: 'description'
};

exports.Prisma.EmailTemplateRecipientTagOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  slug: 'slug',
  name: 'name',
  description: 'description',
  query_information: 'query_information'
};

exports.Prisma.EmailTemplateOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  slug: 'slug',
  name: 'name',
  subject: 'subject',
  template_body: 'template_body'
};

exports.Prisma.EmailTemplateAssignmentOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  email_to: 'email_to'
};

exports.Prisma.EmailTemplateCcBccOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  email_to: 'email_to'
};

exports.Prisma.EmailProcessJobOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  email_template_process_slug: 'email_template_process_slug',
  unique_id: 'unique_id',
  prefill_data: 'prefill_data',
  attachments_path: 'attachments_path',
  attachments_name: 'attachments_name'
};

exports.Prisma.WhatsappProcessJobOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  whatsapp_template_process_slug: 'whatsapp_template_process_slug',
  unique_id: 'unique_id',
  prefill_data: 'prefill_data',
  attachments_path: 'attachments_path',
  attachments_name: 'attachments_name'
};

exports.Prisma.WhatsappTemplateProcessOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  name: 'name',
  slug: 'slug',
  query_information: 'query_information'
};

exports.Prisma.WhatsappTemplateTagOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  slug: 'slug',
  name: 'name',
  description: 'description'
};

exports.Prisma.WhatsappTemplateRecipientTagOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  slug: 'slug',
  name: 'name',
  description: 'description',
  query_information: 'query_information'
};

exports.Prisma.WhatsappTemplateOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  slug: 'slug',
  name: 'name',
  message: 'message'
};

exports.Prisma.WhatsappTemplateAssignmentOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  whatsapp_to: 'whatsapp_to'
};

exports.Prisma.NotificationJobOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  process_slug: 'process_slug',
  notification_to: 'notification_to',
  notification_subject: 'notification_subject',
  notification_content: 'notification_content',
  attachments_path: 'attachments_path',
  attachments_name: 'attachments_name',
  notification_cc: 'notification_cc',
  notification_bcc: 'notification_bcc',
  notification_type_id: 'notification_type_id',
  notification_status_id: 'notification_status_id'
};

exports.Prisma.CarouselTemplateOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  name: 'name',
  slug: 'slug',
  description: 'description'
};

exports.Prisma.CarouselTemplateLineItemOrderByRelevanceFieldEnum = {
  name: 'name',
  slug: 'slug',
  description: 'description',
  image_url: 'image_url',
  video_url: 'video_url',
  clickable_link: 'clickable_link'
};

exports.Prisma.ImportTemplateOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  name: 'name',
  slug: 'slug',
  description: 'description',
  email_process_slug: 'email_process_slug',
  job_type: 'job_type'
};

exports.Prisma.ImportTemplateLineItemOrderByRelevanceFieldEnum = {
  field_name: 'field_name',
  display_name: 'display_name',
  field_table: 'field_table',
  default_value: 'default_value',
  check_reg_exp: 'check_reg_exp',
  unique_query: 'unique_query',
  foreign_query: 'foreign_query',
  enum_values: 'enum_values',
  foreign_table: 'foreign_table',
  foreign_column: 'foreign_column',
  individual_column: 'individual_column'
};

exports.Prisma.ImportTemplateQueriesOrderByRelevanceFieldEnum = {
  query_string: 'query_string',
  query_name: 'query_name'
};

exports.Prisma.ImportJobOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  name: 'name',
  description: 'description',
  sequence_number: 'sequence_number',
  job_status: 'job_status',
  file_path: 'file_path',
  file_name: 'file_name'
};

exports.Prisma.ImportJobLineItemOrderByRelevanceFieldEnum = {
  job_status: 'job_status'
};

exports.Prisma.ExportTemplateOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  name: 'name',
  slug: 'slug',
  description: 'description',
  data_filepath: 'data_filepath'
};

exports.Prisma.ExportTemplateLineItemOrderByRelevanceFieldEnum = {
  field_name: 'field_name',
  display_name: 'display_name',
  field_table: 'field_table',
  default_value: 'default_value',
  column_name: 'column_name',
  individual_column: 'individual_column'
};

exports.Prisma.ExportTemplateQueriesOrderByRelevanceFieldEnum = {
  query_string: 'query_string',
  query_name: 'query_name',
  query_procedure: 'query_procedure'
};

exports.Prisma.StatusOrderByRelevanceFieldEnum = {
  name: 'name',
  slug: 'slug',
  description: 'description'
};

exports.Prisma.CategoryTypesOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  category_type_id: 'category_type_id',
  name: 'name',
  description: 'description'
};

exports.Prisma.CategoriesOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  category_type_id: 'category_type_id',
  category_id: 'category_id',
  parent_id: 'parent_id',
  name: 'name',
  description: 'description'
};

exports.Prisma.ConfigurationsOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  config_key: 'config_key',
  category_id: 'category_id',
  config_value: 'config_value',
  config_file_value: 'config_file_value',
  config_value_type: 'config_value_type',
  config_field_type: 'config_field_type'
};

exports.Prisma.UserConfigurationsOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  config_key: 'config_key',
  category_id: 'category_id',
  config_value: 'config_value',
  config_file_value: 'config_file_value',
  config_value_type: 'config_value_type',
  config_field_type: 'config_field_type'
};

exports.Prisma.FileUploadLogOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  doc_name: 'doc_name',
  org_name: 'org_name',
  extension: 'extension',
  description: 'description'
};

exports.Prisma.DataTransferQueriesOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  select_query: 'select_query',
  insert_query: 'insert_query',
  transfer_type: 'transfer_type',
  job_name: 'job_name',
  destination_table: 'destination_table',
  command_type: 'command_type'
};

exports.Prisma.DeviceRegistrationOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  device_name: 'device_name',
  device_unique_id: 'device_unique_id'
};

exports.Prisma.PoliciesOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  slug: 'slug',
  name: 'name',
  description: 'description'
};

exports.Prisma.AppversionsOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  type: 'type',
  version_type: 'version_type',
  version: 'version',
  description: 'description',
  developed_by: 'developed_by'
};

exports.Prisma.ScheduledJobOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  timing: 'timing',
  cron_url: 'cron_url',
  description: 'description'
};

exports.Prisma.ScheduledJobLogsOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  executed_statement: 'executed_statement',
  schedule_status: 'schedule_status',
  response: 'response'
};

exports.Prisma.ApprovalWorkflowOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  name: 'name',
  description: 'description',
  slug: 'slug',
  query_information: 'query_information',
  url: 'url'
};

exports.Prisma.ApprovalWorkflowApproverTagOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  slug: 'slug',
  name: 'name',
  description: 'description',
  query_information: 'query_information'
};

exports.Prisma.ApprovalWorkflowAssignmentOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  approver: 'approver',
  approve_query_information: 'approve_query_information',
  reject_query_information: 'reject_query_information'
};

exports.Prisma.ApprovalProcessJobOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  approval_workflow_slug: 'approval_workflow_slug',
  sequence_no: 'sequence_no',
  description: 'description',
  primary_table: 'primary_table',
  screen_id: 'screen_id',
  prefill_data: 'prefill_data',
  details: 'details'
};

exports.Prisma.ApprovalProcessJobWorkflowOrderByRelevanceFieldEnum = {
  approval_process_job_id: 'approval_process_job_id',
  approval_workflow_slug: 'approval_workflow_slug',
  approval_process_job_name: 'approval_process_job_name',
  approval_process_job_description: 'approval_process_job_description',
  approve_query_information: 'approve_query_information',
  reject_query_information: 'reject_query_information',
  primary_table: 'primary_table',
  sequence_no: 'sequence_no',
  screen_id: 'screen_id',
  prefill_data: 'prefill_data',
  url: 'url',
  approver: 'approver',
  reason: 'reason',
  details: 'details'
};

exports.Prisma.ApprovalProcessJobWorkflowUserOrderByRelevanceFieldEnum = {
  uuid: 'uuid'
};

exports.Prisma.DelegationOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  reason: 'reason'
};

exports.Prisma.SchemaChunkOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  table_name: 'table_name',
  chunk: 'chunk'
};

exports.Prisma.EmbeddingVectorLogsOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  table_name: 'table_name'
};

exports.Prisma.OpenaiUsageLogOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  prompt: 'prompt',
  generated_sql: 'generated_sql'
};

exports.Prisma.QueryExecutionLogOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  query: 'query'
};

exports.Prisma.ChildProcessOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  name: 'name',
  slug: 'slug',
  description: 'description',
  command: 'command'
};

exports.Prisma.ChildProcessLogOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  process_status: 'process_status',
  output: 'output'
};

exports.Prisma.OrganizationsOrderByRelevanceFieldEnum = {
  uuid: 'uuid',
  name: 'name',
  code: 'code',
  description: 'description'
};
exports.UserRole = exports.$Enums.UserRole = {
  super_admin: 'super_admin',
  company_admin: 'company_admin',
  admin: 'admin',
  user: 'user'
};

exports.ProcessStatus = exports.$Enums.ProcessStatus = {
  under_approval: 'under_approval',
  approved: 'approved',
  rejected: 'rejected',
  submitted: 'submitted',
  created: 'created',
  not_appear: 'not_appear'
};

exports.Gender = exports.$Enums.Gender = {
  male: 'male',
  female: 'female',
  others: 'others'
};

exports.OtpPurpose = exports.$Enums.OtpPurpose = {
  login: 'login',
  password_reset: 'password_reset',
  verify_email: 'verify_email',
  others: 'others'
};

exports.aboutType = exports.$Enums.aboutType = {
  lcp: 'lcp',
  project: 'project'
};

exports.ReportType = exports.$Enums.ReportType = {
  lcp: 'lcp',
  powerbi: 'powerbi'
};

exports.ClauseType = exports.$Enums.ClauseType = {
  where: 'where',
  having: 'having'
};

exports.RecipientType = exports.$Enums.RecipientType = {
  tag: 'tag',
  user_id: 'user_id',
  custom: 'custom'
};

exports.sendMailType = exports.$Enums.sendMailType = {
  cc: 'cc',
  bcc: 'bcc'
};

exports.NotificationType = exports.$Enums.NotificationType = {
  email: 'email',
  whatsapp: 'whatsapp'
};

exports.ApproverType = exports.$Enums.ApproverType = {
  tag: 'tag',
  user_id: 'user_id',
  role_id: 'role_id'
};

exports.ApprovalStatus = exports.$Enums.ApprovalStatus = {
  pending: 'pending',
  approval_needed: 'approval_needed',
  approval_completed: 'approval_completed',
  approval_rejected: 'approval_rejected',
  void: 'void'
};

exports.Prisma.ModelName = {
  User: 'User',
  UserDetail: 'UserDetail',
  Designation: 'Designation',
  Department: 'Department',
  RequestLog: 'RequestLog',
  FinancialYear: 'FinancialYear',
  DocumentSequence: 'DocumentSequence',
  AuditLog: 'AuditLog',
  Permissions: 'Permissions',
  Role: 'Role',
  RolePermissions: 'RolePermissions',
  UserRoles: 'UserRoles',
  UserPermissions: 'UserPermissions',
  Otp: 'Otp',
  Language: 'Language',
  LanguageContent: 'LanguageContent',
  Menus: 'Menus',
  MenuItems: 'MenuItems',
  ActionType: 'ActionType',
  EntityType: 'EntityType',
  WizardGroup: 'WizardGroup',
  WizardType: 'WizardType',
  AboutLCP: 'AboutLCP',
  MasterEntity: 'MasterEntity',
  MasterEntityLineItem: 'MasterEntityLineItem',
  FieldType: 'FieldType',
  menuType: 'menuType',
  EmailTemplateProcess: 'EmailTemplateProcess',
  EmailTemplateTag: 'EmailTemplateTag',
  EmailTemplateRecipientTag: 'EmailTemplateRecipientTag',
  EmailTemplateProcessTagsMapping: 'EmailTemplateProcessTagsMapping',
  EmailTemplate: 'EmailTemplate',
  EmailTemplateAssignment: 'EmailTemplateAssignment',
  EmailTemplateCcBcc: 'EmailTemplateCcBcc',
  EmailProcessJob: 'EmailProcessJob',
  WhatsappProcessJob: 'WhatsappProcessJob',
  WhatsappTemplateProcess: 'WhatsappTemplateProcess',
  WhatsappTemplateTag: 'WhatsappTemplateTag',
  WhatsappTemplateRecipientTag: 'WhatsappTemplateRecipientTag',
  WhatsappTemplateProcessTagsMapping: 'WhatsappTemplateProcessTagsMapping',
  WhatsappTemplate: 'WhatsappTemplate',
  WhatsappTemplateAssignment: 'WhatsappTemplateAssignment',
  NotificationJob: 'NotificationJob',
  CarouselTemplate: 'CarouselTemplate',
  CarouselTemplateLineItem: 'CarouselTemplateLineItem',
  ImportTemplate: 'ImportTemplate',
  ImportTemplateLineItem: 'ImportTemplateLineItem',
  ImportTemplateQueries: 'ImportTemplateQueries',
  ImportJob: 'ImportJob',
  ImportJobLineItem: 'ImportJobLineItem',
  ExportTemplate: 'ExportTemplate',
  ExportTemplateLineItem: 'ExportTemplateLineItem',
  ExportTemplateQueries: 'ExportTemplateQueries',
  Status: 'Status',
  CategoryTypes: 'CategoryTypes',
  Categories: 'Categories',
  Configurations: 'Configurations',
  UserConfigurations: 'UserConfigurations',
  FileUploadLog: 'FileUploadLog',
  DataTransferQueries: 'DataTransferQueries',
  DeviceRegistration: 'DeviceRegistration',
  Policies: 'Policies',
  UserPolicies: 'UserPolicies',
  RolePolicies: 'RolePolicies',
  Appversions: 'Appversions',
  ScheduledJob: 'ScheduledJob',
  ScheduledJobLogs: 'ScheduledJobLogs',
  ApprovalWorkflow: 'ApprovalWorkflow',
  ApprovalWorkflowApproverTag: 'ApprovalWorkflowApproverTag',
  ApprovalWorkflowAssignment: 'ApprovalWorkflowAssignment',
  ApprovalProcessJob: 'ApprovalProcessJob',
  ApprovalProcessJobWorkflow: 'ApprovalProcessJobWorkflow',
  ApprovalProcessJobWorkflowUser: 'ApprovalProcessJobWorkflowUser',
  Delegation: 'Delegation',
  SchemaChunk: 'SchemaChunk',
  EmbeddingVectorLogs: 'EmbeddingVectorLogs',
  OpenaiUsageLog: 'OpenaiUsageLog',
  QueryExecutionLog: 'QueryExecutionLog',
  ChildProcess: 'ChildProcess',
  ChildProcessLog: 'ChildProcessLog',
  Organizations: 'Organizations'
};

/**
 * This is a stub Prisma Client that will error at runtime if called.
 */
class PrismaClient {
  constructor() {
    return new Proxy(this, {
      get(target, prop) {
        let message
        const runtime = getRuntime()
        if (runtime.isEdge) {
          message = `PrismaClient is not configured to run in ${runtime.prettyName}. In order to run Prisma Client on edge runtime, either:
- Use Prisma Accelerate: https://pris.ly/d/accelerate
- Use Driver Adapters: https://pris.ly/d/driver-adapters
`;
        } else {
          message = 'PrismaClient is unable to run in this browser environment, or has been bundled for the browser (running in `' + runtime.prettyName + '`).'
        }
        
        message += `
If this is unexpected, please open an issue: https://pris.ly/prisma-prisma-bug-report`

        throw new Error(message)
      }
    })
  }
}

exports.PrismaClient = PrismaClient

Object.assign(exports, Prisma)
