
Object.defineProperty(exports, "__esModule", { value: true });

const {
  Decimal,
  objectEnumValues,
  makeStrictEnum,
  Public,
  getRuntime,
} = require('./runtime/index-browser.js')


const Prisma = {}

exports.Prisma = Prisma
exports.$Enums = {}

/**
 * Prisma Client JS version: 5.14.0
 * Query Engine version: e9771e62de70f79a5e1c604a2d7c8e2a0a874b48
 */
Prisma.prismaVersion = {
  client: "5.14.0",
  engine: "e9771e62de70f79a5e1c604a2d7c8e2a0a874b48"
}

Prisma.PrismaClientKnownRequestError = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`PrismaClientKnownRequestError is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)};
Prisma.PrismaClientUnknownRequestError = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`PrismaClientUnknownRequestError is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.PrismaClientRustPanicError = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`PrismaClientRustPanicError is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.PrismaClientInitializationError = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`PrismaClientInitializationError is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.PrismaClientValidationError = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`PrismaClientValidationError is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.NotFoundError = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`NotFoundError is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.Decimal = Decimal

/**
 * Re-export of sql-template-tag
 */
Prisma.sql = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`sqltag is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.empty = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`empty is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.join = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`join is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.raw = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`raw is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.validator = Public.validator

/**
* Extensions
*/
Prisma.getExtensionContext = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`Extensions.getExtensionContext is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.defineExtension = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`Extensions.defineExtension is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}

/**
 * Shorthand utilities for JSON filtering
 */
Prisma.DbNull = objectEnumValues.instances.DbNull
Prisma.JsonNull = objectEnumValues.instances.JsonNull
Prisma.AnyNull = objectEnumValues.instances.AnyNull

Prisma.NullTypes = {
  DbNull: objectEnumValues.classes.DbNull,
  JsonNull: objectEnumValues.classes.JsonNull,
  AnyNull: objectEnumValues.classes.AnyNull
}

/**
 * Enums
 */

exports.Prisma.TransactionIsolationLevel = makeStrictEnum({
  Serializable: 'Serializable'
});

exports.Prisma.StatusScalarFieldEnum = {
  id: 'id',
  name: 'name',
  slug: 'slug',
  description: 'description',
  status_id: 'status_id',
  transfer_status: 'transfer_status'
};

exports.Prisma.FieldTypeScalarFieldEnum = {
  id: 'id',
  field_type: 'field_type',
  company_id: 'company_id',
  status_id: 'status_id',
  created_at: 'created_at',
  transfer_status: 'transfer_status'
};

exports.Prisma.RoleScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  name: 'name',
  description: 'description',
  status_id: 'status_id',
  company_id: 'company_id',
  created_by: 'created_by',
  updated_by: 'updated_by',
  deleted_by: 'deleted_by',
  created_at: 'created_at',
  updated_at: 'updated_at',
  deleted_at: 'deleted_at',
  transfer_status: 'transfer_status'
};

exports.Prisma.DepartmentScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  code: 'code',
  name: 'name',
  description: 'description',
  status_id: 'status_id',
  department_head_id: 'department_head_id',
  company_id: 'company_id',
  created_at: 'created_at',
  created_by: 'created_by',
  updated_at: 'updated_at',
  updated_by: 'updated_by',
  deleted_at: 'deleted_at',
  deleted_by: 'deleted_by',
  transfer_status: 'transfer_status'
};

exports.Prisma.DesignationScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  code: 'code',
  name: 'name',
  description: 'description',
  status_id: 'status_id',
  company_id: 'company_id',
  created_at: 'created_at',
  created_by: 'created_by',
  updated_at: 'updated_at',
  updated_by: 'updated_by',
  deleted_at: 'deleted_at',
  deleted_by: 'deleted_by',
  transfer_status: 'transfer_status'
};

exports.Prisma.UserScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  username: 'username',
  email: 'email',
  email_verified: 'email_verified',
  password: 'password',
  status_id: 'status_id',
  role: 'role',
  company_id: 'company_id',
  created_by: 'created_by',
  updated_by: 'updated_by',
  deleted_by: 'deleted_by',
  created_at: 'created_at',
  updated_at: 'updated_at',
  deleted_at: 'deleted_at',
  last_login: 'last_login',
  last_login_device: 'last_login_device',
  transfer_status: 'transfer_status'
};

exports.Prisma.UserDetailScalarFieldEnum = {
  id: 'id',
  user_id: 'user_id',
  code: 'code',
  first_name: 'first_name',
  last_name: 'last_name',
  designation_id: 'designation_id',
  department_id: 'department_id',
  profile_pic: 'profile_pic',
  dob: 'dob',
  country_code: 'country_code',
  phone_number: 'phone_number',
  gender: 'gender',
  user_time_zone: 'user_time_zone',
  address: 'address',
  culture: 'culture',
  company_id: 'company_id',
  created_by: 'created_by',
  updated_by: 'updated_by',
  deleted_by: 'deleted_by',
  created_at: 'created_at',
  updated_at: 'updated_at',
  deleted_at: 'deleted_at',
  transfer_status: 'transfer_status'
};

exports.Prisma.UserRolesScalarFieldEnum = {
  user_id: 'user_id',
  role_id: 'role_id',
  company_id: 'company_id',
  transfer_status: 'transfer_status'
};

exports.Prisma.CategoryTypesScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  category_type_id: 'category_type_id',
  name: 'name',
  description: 'description',
  transfer_status: 'transfer_status',
  company_id: 'company_id',
  created_at: 'created_at',
  created_by: 'created_by',
  updated_at: 'updated_at',
  updated_by: 'updated_by',
  deleted_at: 'deleted_at',
  deleted_by: 'deleted_by'
};

exports.Prisma.CategoriesScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  category_type_id: 'category_type_id',
  category_id: 'category_id',
  parent_id: 'parent_id',
  name: 'name',
  description: 'description',
  company_id: 'company_id',
  created_at: 'created_at',
  created_by: 'created_by',
  updated_at: 'updated_at',
  updated_by: 'updated_by',
  deleted_at: 'deleted_at',
  deleted_by: 'deleted_by',
  transfer_status: 'transfer_status'
};

exports.Prisma.ConfigurationsScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  order_no: 'order_no',
  config_key: 'config_key',
  category_id: 'category_id',
  config_value: 'config_value',
  config_file_value: 'config_file_value',
  config_value_type: 'config_value_type',
  config_field_type: 'config_field_type',
  display_config: 'display_config',
  company_id: 'company_id',
  created_at: 'created_at',
  created_by: 'created_by',
  updated_at: 'updated_at',
  updated_by: 'updated_by',
  deleted_at: 'deleted_at',
  deleted_by: 'deleted_by',
  transfer_status: 'transfer_status'
};

exports.Prisma.MenuTypeScalarFieldEnum = {
  id: 'id',
  name: 'name',
  status_id: 'status_id',
  company_id: 'company_id',
  created_at: 'created_at',
  transfer_status: 'transfer_status'
};

exports.Prisma.MenusScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  name: 'name',
  slug: 'slug',
  description: 'description',
  menu_type: 'menu_type',
  status_id: 'status_id',
  company_id: 'company_id',
  created_by: 'created_by',
  updated_by: 'updated_by',
  deleted_by: 'deleted_by',
  created_at: 'created_at',
  updated_at: 'updated_at',
  deleted_at: 'deleted_at',
  transfer_status: 'transfer_status'
};

exports.Prisma.WizardGroupScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  name: 'name',
  slug: 'slug',
  description: 'description',
  status_id: 'status_id',
  created_at: 'created_at',
  company_id: 'company_id',
  transfer_status: 'transfer_status'
};

exports.Prisma.WizardTypeScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  name: 'name',
  description: 'description',
  company_id: 'company_id',
  transfer_status: 'transfer_status'
};

exports.Prisma.MasterEntityScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  name: 'name',
  entity_name: 'entity_name',
  entity_type: 'entity_type',
  primary_table: 'primary_table',
  associated_tables: 'associated_tables',
  query_information: 'query_information',
  form_information: 'form_information',
  add_query_information: 'add_query_information',
  edit_query_information: 'edit_query_information',
  preset_query_information: 'preset_query_information',
  static_page_content: 'static_page_content',
  dashboard_wizard_group_id: 'dashboard_wizard_group_id',
  dashboard_wizard_type: 'dashboard_wizard_type',
  dashboard_wizard_rows: 'dashboard_wizard_rows',
  dashboard_wizard_columns: 'dashboard_wizard_columns',
  dashboard_wizard_order_no: 'dashboard_wizard_order_no',
  dashboard_wizard_options: 'dashboard_wizard_options',
  status_id: 'status_id',
  company_id: 'company_id',
  created_at: 'created_at',
  deleted_at: 'deleted_at',
  transfer_status: 'transfer_status'
};

exports.Prisma.MasterEntityLineItemScalarFieldEnum = {
  id: 'id',
  master_grid_id: 'master_grid_id',
  field_name: 'field_name',
  display_name: 'display_name',
  width: 'width',
  format: 'format',
  is_default: 'is_default',
  order_no: 'order_no',
  is_grid_column: 'is_grid_column',
  is_searchable: 'is_searchable',
  clause_type: 'clause_type',
  is_sortable: 'is_sortable',
  field_type_id: 'field_type_id',
  status_id: 'status_id',
  company_id: 'company_id',
  created_at: 'created_at',
  transfer_status: 'transfer_status'
};

exports.Prisma.PermissionsScalarFieldEnum = {
  id: 'id',
  name: 'name',
  slug: 'slug',
  entity_id: 'entity_id',
  order_no: 'order_no',
  status_id: 'status_id',
  company_id: 'company_id',
  created_at: 'created_at',
  transfer_status: 'transfer_status'
};

exports.Prisma.MenuItemsScalarFieldEnum = {
  id: 'id',
  menu_id: 'menu_id',
  name: 'name',
  target: 'target',
  parent_id: 'parent_id',
  permission_id: 'permission_id',
  entity_id: 'entity_id',
  link_type: 'link_type',
  order_no: 'order_no',
  menu_img: 'menu_img',
  short_cut_keys: 'short_cut_keys',
  status_id: 'status_id',
  company_id: 'company_id',
  created_by: 'created_by',
  updated_by: 'updated_by',
  deleted_by: 'deleted_by',
  created_at: 'created_at',
  updated_at: 'updated_at',
  deleted_at: 'deleted_at',
  transfer_status: 'transfer_status'
};

exports.Prisma.UserPermissionsScalarFieldEnum = {
  user_id: 'user_id',
  permission_id: 'permission_id',
  company_id: 'company_id',
  transfer_status: 'transfer_status'
};

exports.Prisma.RolePermissionsScalarFieldEnum = {
  role_id: 'role_id',
  permission_id: 'permission_id',
  company_id: 'company_id'
};

exports.Prisma.LanguageScalarFieldEnum = {
  id: 'id',
  uuid: 'uuid',
  name: 'name',
  name_in_english: 'name_in_english',
  flag: 'flag',
  code: 'code',
  rtl: 'rtl',
  description: 'description',
  status_id: 'status_id',
  company_id: 'company_id',
  created_by: 'created_by',
  updated_by: 'updated_by',
  deleted_by: 'deleted_by',
  created_at: 'created_at',
  updated_at: 'updated_at',
  deleted_at: 'deleted_at',
  transfer_status: 'transfer_status'
};

exports.Prisma.LanguageContentScalarFieldEnum = {
  id: 'id',
  language_id: 'language_id',
  key_content: 'key_content',
  values: 'values',
  status_id: 'status_id',
  company_id: 'company_id',
  created_at: 'created_at',
  transfer_status: 'transfer_status'
};

exports.Prisma.SortOrder = {
  asc: 'asc',
  desc: 'desc'
};

exports.Prisma.NullsOrder = {
  first: 'first',
  last: 'last'
};


exports.Prisma.ModelName = {
  Status: 'Status',
  FieldType: 'FieldType',
  Role: 'Role',
  Department: 'Department',
  Designation: 'Designation',
  User: 'User',
  UserDetail: 'UserDetail',
  UserRoles: 'UserRoles',
  CategoryTypes: 'CategoryTypes',
  Categories: 'Categories',
  Configurations: 'Configurations',
  menuType: 'menuType',
  Menus: 'Menus',
  WizardGroup: 'WizardGroup',
  WizardType: 'WizardType',
  MasterEntity: 'MasterEntity',
  MasterEntityLineItem: 'MasterEntityLineItem',
  Permissions: 'Permissions',
  MenuItems: 'MenuItems',
  UserPermissions: 'UserPermissions',
  RolePermissions: 'RolePermissions',
  Language: 'Language',
  LanguageContent: 'LanguageContent'
};

/**
 * This is a stub Prisma Client that will error at runtime if called.
 */
class PrismaClient {
  constructor() {
    return new Proxy(this, {
      get(target, prop) {
        let message
        const runtime = getRuntime()
        if (runtime.isEdge) {
          message = `PrismaClient is not configured to run in ${runtime.prettyName}. In order to run Prisma Client on edge runtime, either:
- Use Prisma Accelerate: https://pris.ly/d/accelerate
- Use Driver Adapters: https://pris.ly/d/driver-adapters
`;
        } else {
          message = 'PrismaClient is unable to run in this browser environment, or has been bundled for the browser (running in `' + runtime.prettyName + '`).'
        }
        
        message += `
If this is unexpected, please open an issue: https://pris.ly/prisma-prisma-bug-report`

        throw new Error(message)
      }
    })
  }
}

exports.PrismaClient = PrismaClient

Object.assign(exports, Prisma)
