#pragma once

#include <vector>
#include <BoundDatum.h>

namespace mssql
{
	class ResultSet;
	class QueryOperationParams;

	class BoundDatumSet
	{
	public:	
		typedef vector<shared_ptr<BoundDatum>> param_bindings;
		BoundDatumSet();
		BoundDatumSet(const shared_ptr<QueryOperationParams> params);
		bool reserve(const shared_ptr<ResultSet> &set, size_t row_count) const;
		bool bind(Local<Array> &node_params);
		Local<Array> unbind() const;	
		void clear() { _bindings->clear(); }
		size_t size() { return _bindings->size(); }
		shared_ptr<BoundDatum> & atIndex(int i) { return (*_bindings)[i]; }
		param_bindings::iterator begin() { return _bindings->begin(); }
		param_bindings::iterator end() { return _bindings->end(); }

		char * err;
		uint32_t first_error;

	private:
		bool tvp(Local<Value> &v) const;
		int _output_param_count;
		shared_ptr<param_bindings> _bindings;
		shared_ptr<QueryOperationParams> _params;
	};
}
