//---------------------------------------------------------------------------------------------------------------------------------
// File: OdbcOperation.h
// Contents: ODBC Operation objects called on background thread
// 
// Copyright Microsoft Corporation and contributors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
//
// You may obtain a copy of the License at:
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//---------------------------------------------------------------------------------------------------------------------------------

#pragma once

#include <nan.h>
#include <mutex>
#include <queue>

namespace mssql
{
	using namespace std;
	using namespace v8;

	class OdbcConnection;
	class OdbcStatement;
	class OdbcOperation;

	class OdbcOperationQueue
	{
	public:
		OdbcOperationQueue(const shared_ptr<OdbcConnection>& connection);
		void enqueue(shared_ptr<OdbcOperation> op);
		void dispatch();

	private:
		shared_ptr<queue<shared_ptr<OdbcOperation>>> _operations;
		mutex g_i_mutex;
	};	
}

