//---------------------------------------------------------------------------------------------------------------------------------
// File: OdbcOperation.h
// Contents: ODBC Operation objects called on background thread
// 
// Copyright Microsoft Corporation and contributors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
//
// You may obtain a copy of the License at:
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//---------------------------------------------------------------------------------------------------------------------------------

#pragma once

#include "OdbcOperation.h"

namespace mssql
{
	using namespace std;
	using namespace v8;

	class OdbcConnection;

	class UnbindOperation : public OdbcOperation
	{
	public:

		UnbindOperation(shared_ptr<OdbcConnection> connection, size_t queryId, Local<Object> callback)
			: OdbcOperation(connection, callback)
		{
			_statementId = queryId;
		}

		bool TryInvokeOdbc() override;

		Local<Value> CreateCompletionArg() override;
	};
}

