import { gridSeeder } from './app-seeds/master-grid-seeds';
import { formEntitiesSeeder } from './app-seeds/form-entity-seeds';
import { permissionsSeeder } from './app-seeds/permission-seeds';
import { menuItemsSeeder } from './app-seeds/menuItems-seeds';
import { languageContentSeeds } from './app-seeds/languageContent-seeds';
import { policiesSeeder } from './app-seeds/policy-seeds';
import { documentSequenceSeeder } from './app-seeds/document-sequence-seeds';
import { userConfigurationsSeeder } from './app-seeds/user-configurations-seeds';
import { organizationSeeder } from './app-seeds/organizations-seeds';
import { usersSeeder } from './app-seeds/user-seeds';
import { userRolesSeeds } from './app-seeds/userRoles-seeds';
import { roleSeeds } from './app-seeds/role-seeds';

const company_id = 1;

async function applicationSeeders() {
  try {

    await documentSequenceSeeder(company_id);
    await gridSeeder(company_id);
    await formEntitiesSeeder(company_id);
    await permissionsSeeder(company_id);
    await menuItemsSeeder(company_id);
    await languageContentSeeds(company_id);
    await policiesSeeder(company_id);
    await userConfigurationsSeeder(company_id);
    await organizationSeeder(company_id);
    await usersSeeder(company_id);
    await roleSeeds(company_id);
    await userRolesSeeds(company_id);
  } catch (error) {
    console.log(`Application seeder error: `, error);
  }
}

applicationSeeders();
