import { PrismaClient } from '@prisma/pg/client';
import fs from 'fs';
const prisma = new PrismaClient();

function getCurrentUtcTime() {
  return new Date().toISOString();
}

const configurationsSeed = JSON.parse(
  fs.readFileSync(__dirname + '/json/configurations.json', 'utf-8'),
);

/*let catIdGenerator = {
  prefix: 'a',
  currentIndex: 1,
};

// Function to generate a new cat_id
function generateCatId() {
  const catId = `${catIdGenerator.prefix}${catIdGenerator.currentIndex}`;
  catIdGenerator.currentIndex++; // Increment the index for the next id
  return catId;
}*/

export async function configurationsSeeder(company_id: number) {
  try {
    let user = await prisma.user.findFirst({
      where: { company_id: company_id, role: 'super_admin' },
    });
    if (!user) {
      console.log(
        `Role seeder failed: admin user not available for company id ${company_id}`,
      );
      return false;
    }

    const createdBy = user.id;
    const utcNow = getCurrentUtcTime();

    for (const catType of configurationsSeed) {
      /*if (!catType.cats || !catType.cats.length) {
        console.log(
          `Skipping category type ${catType.cat_type_name} as it has no cats.`,
        );
        continue; 
      }*/
      // Upsert CategoryType
      const categoryType = await prisma.categoryTypes.upsert({
        where: {
          company_id_name: { company_id, name: catType.cat_type_name },
        },
        update: {},
        create: {
          category_type_id: catType.category_type_id,
          name: catType.cat_type_name,
          description: catType.cat_type_description,
          company_id: company_id,
          created_by: createdBy,
          created_at: utcNow,
        },
      });

      if (catType.cats) {
        if (catType.cats.length) {
          for (const category of catType.cats) {
            //const idGenerator: any = generateCatId();

            // Upsert Category
            const newCategory = await prisma.categories.upsert({
              where: {
                company_id_category_id_name: { company_id, category_id: category.category_id, name: category.cat_name },
              },
              update: {},
              create: {
                category_id: category.category_id,

                name: category.cat_name,
                description: category.cat_description,
                category_type_id: categoryType.category_type_id,
                company_id: company_id,
                created_by: createdBy,
                created_at: utcNow,
              },
            });

            // Ensure `cat_configs` is defined before proceeding
            /*if (!category.cat_configs || !category.cat_configs.length) {
          console.log(
            `Skipping category ${category.cat_name} as it has no configs.`,
          );
          continue; 
        }*/
            // Upsert Configurations
            if (category.cat_configs) {
              if (category.cat_configs.length) {
                for (const config of category.cat_configs) {
                  const configFileValue: any = config.config_file_value;
                  await prisma.configurations.upsert({
                    where: {
                      company_id_config_key: {
                        company_id,
                        config_key: config.config_key,
                      },
                    },
                    update: {},
                    create: {
                      order_no: config.order_no,
                      config_key: config.config_key,
                      config_value: config.config_value
                        ? config.config_value
                        : 'null',
                        config_select_json: config.config_select_json
                        ? config.config_select_json
                        : 'null',
                      config_file_value: configFileValue,
                      config_value_type: config.config_value_type,
                      config_field_type: config.config_field_type,
                      category_id: newCategory.category_id,
                      company_id: company_id,
                      created_by: createdBy,
                      created_at: utcNow,
                    },
                  });
                }
              }
            }
          }
        }
      }
    }
  } catch (error) {
    console.error(`Error in configurationsSeeder: ${error}`);
    throw error;
  }
}
