import { PrismaClient } from '@prisma/pg/client';
import fs from 'fs';
const prisma = new PrismaClient();

function getCurrentUtcTime() {
  return new Date().toISOString();
}

const configurationsSeed = JSON.parse(
  fs.readFileSync(__dirname + '/json/userconfigurations.json', 'utf-8'),
);

/*let catIdGenerator = {
  prefix: 'a',
  currentIndex: 1,
};

// Function to generate a new cat_id
function generateCatId() {
  const catId = `${catIdGenerator.prefix}${catIdGenerator.currentIndex}`;
  catIdGenerator.currentIndex++; // Increment the index for the next id
  return catId;
}*/

export async function userConfigurationsSeeder(company_id: number) {
  try {
    // Fetch all users for the company
    const users = await prisma.user.findMany({ where: { company_id } });
    if (!users.length) {
      console.log(
        `Role seeder failed: no users available for company id ${company_id}`,
      );
      return false;
    }

    const utcNow = getCurrentUtcTime();

    for (const user of users) {
      const createdBy = user.id;
      for (const catType of configurationsSeed) {
        // Upsert CategoryType
        const categoryType = await prisma.categoryTypes.upsert({
          where: {
            company_id_name: { company_id, name: catType.cat_type_name },
          },
          update: {},
          create: {
            category_type_id: catType.category_type_id,
            name: catType.cat_type_name,
            description: catType.cat_type_description,
            company_id: company_id,
            created_by: createdBy,
            created_at: utcNow,
          },
        });

        if (catType.cats) {
          if (catType.cats.length) {
            for (const category of catType.cats) {
              // Upsert Category
              const newCategory = await prisma.categories.upsert({
                where: {
                  company_id_category_id_name: { company_id, category_id: category.category_id, name: category.cat_name },
                },
                update: {},
                create: {
                  category_id: category.category_id,
                  name: category.cat_name,
                  description: category.cat_description,
                  category_type_id: categoryType.category_type_id,
                  company_id: company_id,
                  created_by: createdBy,
                  created_at: utcNow,
                  status_id:category.status_id
                },
              });

              // Upsert UserConfigurations for each user
              if (category.cat_configs) {
                if (category.cat_configs.length) {
                  for (const config of category.cat_configs) {
                    const configFileValue: any = config.config_file_value;
                    await prisma.userConfigurations.upsert({
                      where: {
                        company_id_config_key_user_id: {
                          company_id,
                          config_key: config.config_key,
                          user_id: user.id,
                        },
                      },
                      update: {},
                      create: {
                        order_no: config.order_no,
                        config_key: config.config_key,
                        config_value: config.config_value
                          ? config.config_value
                          : 'null',
                        config_select_json: config.config_select_json
                          ? config.config_select_json
                          : 'null',
                        config_file_value: configFileValue,
                        config_value_type: config.config_value_type,
                        config_field_type: config.config_field_type,
                        category_id: newCategory.category_id,
                        company_id: company_id,
                        user_id: user.id,
                        created_by: createdBy,
                        created_at: utcNow,
                      },
                    });
                  }
                }
              }
            }
          }
        }
      }
    }
  } catch (error) {
    console.error(`Error in userConfigurationsSeeder: ${error}`);
    throw error;
  }
}
