import { PrismaClient } from '@prisma/pg/client'

const prisma = new PrismaClient();

const wizardTypes = [
  { id: 1, name: 'static', description: 'Static' },
  { id: 2, name: 'chart', description: 'Chart' },
];

export async function wizardTypeSeeder(company_id: number) {
  try {
    for (const wizardType of wizardTypes) {
      const existingWizardType = await prisma.wizardType.findUnique({
        where: { id: wizardType.id },
      });

      if (!existingWizardType) {
        await prisma.wizardType.create({
          data: {
            id: wizardType.id,
            name: wizardType.name,
            description: wizardType.description,
            company_id: company_id,
          },
        });
        console.log(
          `Created wizardType with id ${wizardType.id}: ${wizardType.name}`,
        );
      } else {
        console.log(`WizardType with id ${wizardType.id} already exists.`);
      }
    }
  } catch (error) {
    console.error(`Error in wizardTypeSeeder: ${error}`);
    throw error;
  } finally {
    // await prisma.$disconnect();
  }
}
