import { PrismaClient } from '@prisma/sql/client';

const prisma = new PrismaClient();

const actionTypes = [
  { id: 1, name: 'view', description: 'view' },
  { id: 2, name: 'add', description: 'add' },
  { id: 3, name: 'edit', description: 'edit' },
  { id: 4, name: 'delete', description: 'delete' },
  { id: 5, name: 'details', description: 'details' },
  { id: 6, name: 'export_excel', description: 'export_excel' },
  { id: 7, name: 'import', description: 'import' },
  { id: 8, name: 'record_export', description: 'record_export' },
  { id: 9, name: 'assign', description: 'assign' },
  { id: 10, name: 'print', description: 'print' },
];

export async function actionTypeSeeder(company_id: number) {
  try {
    console.log("🚀 Starting ActionType Seeder...");

    await prisma.$transaction(async (tx) => {

      for (const actionType of actionTypes) {
        const existingActionType = await tx.actionType.findUnique({
          where: { id: actionType.id },
        });

        if (!existingActionType) {
          // ✅ Use raw SQL for inserting records
          await tx.$executeRawUnsafe(`
            SET IDENTITY_INSERT action_types ON;
            INSERT INTO action_types (id, name, description, company_id) 
            VALUES (${actionType.id}, '${actionType.name}', '${actionType.description}', ${company_id});
            SET IDENTITY_INSERT action_types OFF;
          `);
          console.log(`✅ Created ActionType with id ${actionType.id}: ${actionType.name}`);
        } else {
          console.log(`🔄 ActionType with id ${actionType.id} already exists.`);
        }
      }
    });

    console.log("✅ ActionType seeder completed successfully.");
  } catch (error) {
    console.error(`❌ Error in actionTypeSeeder: ${error}`);
    throw error;
  } finally {
    await prisma.$disconnect();
  }
}

