"use strict";var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0});const swagger_jsdoc_1=__importDefault(require("swagger-jsdoc")),config_1=require("./config"),swaggerDefinition={openapi:"3.0.0",info:{title:`${config_1.appDetails.appName}`,version:"2.0.0",description:`${config_1.appDetails.appName} API documentation with Swagger`,contact:{name:`${config_1.appDetails.appName}`,url:"",email:`${config_1.appDetails.adminMail}`}},tags:[{name:"Cron",description:`**Note:** Use the server URL **${"`"+config_1.appDetails.baseUrl+"`"}** for these APIs.`},{name:"Auth",description:`**Server:** ${"`"+config_1.appDetails.baseUrl+"api/`"}.`},{name:"Common",description:`**Server:** ${"`"+config_1.appDetails.baseUrl+"api/`"}.`},{name:"Language",description:`**Server:** ${"`"+config_1.appDetails.baseUrl+"api/`"}.`},{name:"Test",description:`**Server:** ${"`"+config_1.appDetails.baseUrl+"api/`"}.`},{name:"OpenAI",description:`**Server:** ${"`"+config_1.appDetails.baseUrl+"api/`"}.`},{name:"Webhook",description:`**Server:** ${"`"+config_1.appDetails.baseUrl+"api/`"}.`}],servers:[{url:`${config_1.appDetails.baseUrl}api/`},{url:`${config_1.appDetails.baseUrl}`}],components:{securitySchemes:{AccessToken:{type:"http",scheme:"bearer",bearerFormat:"JWT",description:"Enter the Bearer token in the following format: `Bearer <token>`"},Language:{type:"apiKey",in:"header",name:"lang"},DeviceId:{type:"apiKey",in:"header",name:"deviceId",description:"Must be <strong>unique device id</strong>"},DeviceType:{type:"apiKey",in:"header",name:"deviceType",description:"It should be - <strong>android, ios,</strong> or <strong>web</strong>"},FcmToken:{type:"apiKey",in:"header",name:"fcmToken"}}},security:[{Language:[]}],paths:{"/cron/truncate-audit-logs":{get:{tags:["Cron"],summary:"truncate audit logs.",description:`\ntruncate the audit logs.\n\n**Note:**\n- **API should not contain the \`/api\` prefix in URL.**\n- **Use the server URL \`${config_1.appDetails.baseUrl}\` for this API.**\n`,responses:{200:{description:"OK"}}}},"/cron/truncate-request-logs":{get:{tags:["Cron"],summary:"truncate request logs.",description:`\ntruncate the request logs.\n\n**Note:**\n- **API should not contain the \`/api\` prefix in URL.**\n- **Use the server URL \`${config_1.appDetails.baseUrl}\` for this API.**\n`,responses:{200:{description:"OK"}}}},"/cron/schedule-import-job":{get:{tags:["Cron"],summary:"Schedule import jobs.",description:`\nProcess the schedule import jobs.\n\n**Note:**\n- **API should not contain the \`/api\` prefix in URL.**\n- **Use the server URL \`${config_1.appDetails.baseUrl}\` for this API.**\n`,responses:{200:{description:"OK"}}}},"/cron/process-email-jobs":{get:{tags:["Cron"],summary:"Process email jobs.",description:`\nProcess the email template content and recipient using inserted email process jobs.\n\n**Note:**\n- **API should not contain the \`/api\` prefix in URL.**\n- **Use the server URL \`${config_1.appDetails.baseUrl}\` for this API.**\n`,responses:{200:{description:"OK"}}}},"/cron/process-whatsapp-jobs":{get:{tags:["Cron"],summary:"Process whatsapp jobs.",description:`\nProcess the whatsapp template content and recipient using inserted whatsapp process jobs.\n\n**Note:**\n- **API should not contain the \`/api\` prefix in URL for whatsapp cron.**\n- **Use the server URL \`${config_1.appDetails.baseUrl}\` for this API.**\n`,responses:{200:{description:"OK"}}}},"/cron/send-notification-jobs":{get:{tags:["Cron"],summary:"Send notification jobs.",description:`\nSend the notifications which are processed by the notification process jobs like email or whatsapp.\n\n**Note:**\n- **API should not contain the \`/api\` prefix in URL.**\n- **Use the server URL \`${config_1.appDetails.baseUrl}\` for this API.**\n`,responses:{200:{description:"OK"}}}},"/datasync/push":{post:{tags:["Data Sync"],summary:"Push data from PostgreSQL to SQLite.",description:"Push data from PostgreSQL to SQLite based on the queries defined in the DataTransferQueryTable.",requestBody:{content:{"application/json":{schema:{type:"object",properties:{dbFileName:{type:"string",description:"SQLite database file path"},serverURL:{type:"string",description:"Server URL for additional configuration ex:http://localhost:3131/"},deviceRegistrationID:{type:"string",description:"Device Registration ID to track the operation"}},required:["dbFileName","serverURL","deviceRegistrationID"]}}}},responses:{200:{description:"Data pushed successfully",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string"}}}}}},500:{description:"Error occurred during the push operation",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string"},error:{type:"string"}}}}}}}}},"/datasync/pull":{post:{tags:["Data Sync"],summary:"Pull data from SQLite to PostgreSQL.",description:"Pull data from SQLite to PostgreSQL based on the queries defined in the DataTransferQueryTable.",requestBody:{content:{"multipart/form-data":{schema:{type:"object",properties:{dbFile:{type:"string",format:"binary",description:"SQLite database file to upload"}},required:["dbFile"]}}}},responses:{200:{description:"Data pulled successfully",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string"}}}}}},400:{description:"Invalid request, missing file or userID",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string"}}}}}},500:{description:"Error occurred during the pull operation",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string"},error:{type:"string"}}}}}}}}}}},options={failOnErrors:!0,definition:swaggerDefinition,apis:[`${__dirname}/@lcp-framework/routes/**/**.sw.routes.ts`,`${__dirname}/app/routes/**/**.sw.routes.ts`,"./@lcp-framework/routes/**/**.sw.routes.js","./app/routes/**/**.sw.routes.js"]},swaggerSpec=(0,swagger_jsdoc_1.default)(options);exports.default=swaggerSpec;