"use strict";var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0});const express_1=__importDefault(require("express")),auth_controller_1=require("../../controller/common/auth.controller"),validate_1=require("../../middlewares/validate"),auth_validate_1=require("../../schema/auth.validate"),jwt_middleware_1=require("../../middlewares/jwt.middleware"),response_1=require("../../utilities/response"),decryptPayload_middleware_1=require("../../middlewares/decryptPayload.middleware"),router=express_1.default.Router();router.post("/:role/login",response_1.requestLimiter,decryptPayload_middleware_1.decryptPayloadMiddleware,(0,validate_1.validateRequest)({params:auth_validate_1.userRoleSchema,body:auth_validate_1.loginDataSchema}),auth_controller_1.authController.login),router.post("/:role/verify/:type/otp",response_1.requestLimiter,decryptPayload_middleware_1.decryptPayloadMiddleware,(0,validate_1.validateRequest)({params:auth_validate_1.otpRoleSchema,body:auth_validate_1.otpVerifySchema}),auth_controller_1.authController.verifyOtp),router.get("/:role/password/request/:email",response_1.requestLimiter,decryptPayload_middleware_1.decryptPayloadMiddleware,(0,validate_1.validateRequest)({params:auth_validate_1.requestPasswordSchema}),auth_controller_1.authController.passwordRequest),router.post("/:role/password/reset",response_1.requestLimiter,decryptPayload_middleware_1.decryptPayloadMiddleware,(0,validate_1.validateRequest)({params:auth_validate_1.userRoleSchema,body:auth_validate_1.resetPasswordSchema}),auth_controller_1.authController.resetPassword),router.post("/:role/register",response_1.requestLimiter,decryptPayload_middleware_1.decryptPayloadMiddleware,(0,validate_1.validateRequest)({params:auth_validate_1.userRoleSchema,body:auth_validate_1.registerDataSchema}),auth_controller_1.authController.register),router.get("/logout",jwt_middleware_1.authenticateToken,decryptPayload_middleware_1.decryptPayloadMiddleware,auth_controller_1.authController.logout),router.get("/profile",jwt_middleware_1.authenticateToken,decryptPayload_middleware_1.decryptPayloadMiddleware,auth_controller_1.authController.myProfile),router.put("/profile",jwt_middleware_1.authenticateToken,decryptPayload_middleware_1.decryptPayloadMiddleware,(0,validate_1.validateRequest)({body:auth_validate_1.profileDataSchema}),auth_controller_1.authController.updateProfile),router.put("/profile/picture",jwt_middleware_1.authenticateToken,decryptPayload_middleware_1.decryptPayloadMiddleware,((e,t,a)=>{console.log("Content-Type:",e.headers["content-type"]),console.log("Files:",e.files),a()}),(0,validate_1.validateRequest)({body:auth_validate_1.profilePicSchema}),auth_controller_1.authController.updateProfilePic),router.put("/config/picture",jwt_middleware_1.authenticateToken,decryptPayload_middleware_1.decryptPayloadMiddleware,((e,t,a)=>{console.log("Content-Type:",e.headers["content-type"]),console.log("Files:",e.files),a()}),auth_controller_1.authController.updateConfigurationsPic),router.put("/export/file",jwt_middleware_1.authenticateToken,decryptPayload_middleware_1.decryptPayloadMiddleware,((e,t,a)=>{console.log("Content-Type:",e.headers["content-type"]),console.log("Files:",e.files),a()}),auth_controller_1.authController.updateExportFile),router.post("/export/get-excel-headers",jwt_middleware_1.authenticateToken,decryptPayload_middleware_1.decryptPayloadMiddleware,auth_controller_1.authController.getExcelHeaders),router.post("/password/change",jwt_middleware_1.authenticateToken,decryptPayload_middleware_1.decryptPayloadMiddleware,(0,validate_1.validateRequest)({body:auth_validate_1.changePasswordSchema}),auth_controller_1.authController.changePassword),router.post("/password/reset-pwd-user",jwt_middleware_1.authenticateToken,decryptPayload_middleware_1.decryptPayloadMiddleware,auth_controller_1.authController.resetPasswordAnyUser),router.delete("/account",jwt_middleware_1.authenticateToken,decryptPayload_middleware_1.decryptPayloadMiddleware,auth_controller_1.authController.deleteAccount),router.get("/permissions",jwt_middleware_1.authenticateToken,decryptPayload_middleware_1.decryptPayloadMiddleware,auth_controller_1.authController.myRoleAndPermissions),router.get("/menus",jwt_middleware_1.authenticateToken,decryptPayload_middleware_1.decryptPayloadMiddleware,auth_controller_1.authController.getUserMenus),router.get("/powerbi/report/generate-embed-token",jwt_middleware_1.authenticateToken,decryptPayload_middleware_1.decryptPayloadMiddleware,(0,validate_1.validateRequest)({query:auth_validate_1.reportDetailSchema}),auth_controller_1.authController.generateReportEmbedToken),exports.default=router;