import { PrismaClient} from '@prisma/pg/client'
import fs from 'fs';
const prisma = new PrismaClient();

export async function fieldTypesSeeder(company_id:number) {
  try {
    const fieldTypes = JSON.parse(fs.readFileSync(__dirname+'/json/field-types.json', 'utf-8'));

    for (const fieldType of fieldTypes) {

      const id = fieldType.id + ((company_id - 1) * fieldTypes.length);

      await prisma.fieldType.upsert({
        where: {
          id
        },
        update: {
          field_type: fieldType.field_type,
          created_at: new Date(),
          company_id
        },
        create: {
          id,
          field_type: fieldType.field_type,
          company_id,
          created_at: new Date()
        }
      });
    }
  } catch (error) {
    console.log(`fieldtype seeder failed.`);
    throw error;
  }
}
