import { PrismaClient } from '@prisma/pg/client'
import fs from 'fs';
const prisma = new PrismaClient();



export async function organizationSeeder(company_id: number) {
  try {
    // Read the organization seed data
    const rows = JSON.parse(
      fs.readFileSync(__dirname + '/json/organizations.json', 'utf-8'),
    );

    // Get the super admin user
    const user = await prisma.user.findFirst({
      where: { company_id: company_id, role: 'super_admin' },
    });

    // Iterate through the rows and process each organization
    for (const row of rows) {
     

      // Insert or update the organization
      await prisma.organizations.upsert({
        where: { company_id_code: { company_id, code: row.code } },
        update: {
          ...row,
          updated_by: user?.id,
        },
        create: {
          ...row,
          company_id,
          created_by: user?.id,
          updated_by: user?.id,
        },
      });

      console.log(`Upserted organization: ${row.name}`);
    }
  } catch (error) {
    console.error(`Error in organizationSeeder: ${error}`);
    throw error;
  } finally {
    // Optionally disconnect Prisma
    // await prisma.$disconnect();
  }
}
