import {
  TIMEZONE_LIST
} from "./chunk-W5EGWSHZ.js";
import {
  require_sweetalert2_all
} from "./chunk-KLTWPXW2.js";
import {
  MenuMapService
} from "./chunk-3FLJCSSF.js";
import {
  ToastrService
} from "./chunk-2YLAF7RI.js";
import {
  CommonSharedModule,
  DynamicFontSizeDirective,
  NgScrollbar,
  NgSelectComponent,
  NgSelectModule,
  Store
} from "./chunk-7NQGM4EA.js";
import {
  CheckboxControlValueAccessor,
  DefaultValueAccessor,
  FormArrayName,
  FormBuilder,
  FormControlName,
  FormGroupDirective,
  FormGroupName,
  FormsModule,
  NgControlStatus,
  NgControlStatusGroup,
  NgModel,
  NgSelectOption,
  NumberValueAccessor,
  ReactiveFormsModule,
  SelectControlValueAccessor,
  TranslatePipe,
  TranslateService,
  Validators,
  ɵNgNoValidate,
  ɵNgSelectMultipleOption
} from "./chunk-NLYGDKUR.js";
import "./chunk-ZEL7H2AL.js";
import {
  ActivatedRoute,
  GridApiService,
  LocalStorageService,
  Router,
  commonConfig,
  environment
} from "./chunk-P7K2QEDI.js";
import {
  ChangeDetectorRef,
  CommonModule,
  NgClass,
  NgForOf,
  NgIf,
  NgSwitch,
  NgSwitchCase,
  Title,
  ɵsetClassDebugInfo,
  ɵɵStandaloneFeature,
  ɵɵadvance,
  ɵɵdefineComponent,
  ɵɵdirectiveInject,
  ɵɵelement,
  ɵɵelementContainerEnd,
  ɵɵelementContainerStart,
  ɵɵelementEnd,
  ɵɵelementStart,
  ɵɵgetCurrentView,
  ɵɵlistener,
  ɵɵnextContext,
  ɵɵpipe,
  ɵɵpipeBind1,
  ɵɵproperty,
  ɵɵpureFunction0,
  ɵɵpureFunction1,
  ɵɵresetView,
  ɵɵrestoreView,
  ɵɵsanitizeUrl,
  ɵɵtemplate,
  ɵɵtext,
  ɵɵtextInterpolate,
  ɵɵtextInterpolate1
} from "./chunk-GKZIWABI.js";
import {
  __async,
  __toESM
} from "./chunk-CVWHNZRK.js";

// src/app/@lcp-framework/pages/user-configuration/user-configuration.component.ts
var import_sweetalert2 = __toESM(require_sweetalert2_all());
var _c0 = () => ({ standalone: true });
var _c1 = (a0) => ({ "!border-white-light !border-b-white text-danger dark:!border-[#191e3a] dark:!border-b-black": a0 });
var _c2 = (a0) => ({ "border-none": a0 });
function UserConfigurationComponent_a_8_Template(rf, ctx) {
  if (rf & 1) {
    const _r1 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "a", 16);
    \u0275\u0275listener("click", function UserConfigurationComponent_a_8_Template_a_click_0_listener() {
      const tab_r2 = \u0275\u0275restoreView(_r1).$implicit;
      const ctx_r2 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r2.switchTab(tab_r2.name));
    });
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const tab_r2 = ctx.$implicit;
    const ctx_r2 = \u0275\u0275nextContext();
    \u0275\u0275property("ngClass", \u0275\u0275pureFunction1(2, _c1, ctx_r2.currentTab === tab_r2.name));
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", tab_r2.name, " ");
  }
}
function UserConfigurationComponent_option_13_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "option", 8);
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const user_r4 = ctx.$implicit;
    \u0275\u0275property("ngValue", user_r4.id);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate(user_r4.org_name ? user_r4.org_name : user_r4.name);
  }
}
function UserConfigurationComponent_ng_container_22_div_1_ng_container_15_tr_1_ng_container_5_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementContainerStart(0);
    \u0275\u0275element(1, "input", 31);
    \u0275\u0275elementContainerEnd();
  }
}
function UserConfigurationComponent_ng_container_22_div_1_ng_container_15_tr_1_ng_container_6_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementContainerStart(0);
    \u0275\u0275element(1, "input", 32);
    \u0275\u0275elementContainerEnd();
  }
}
function UserConfigurationComponent_ng_container_22_div_1_ng_container_15_tr_1_ng_container_7_div_2_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 36);
    \u0275\u0275element(1, "img", 37);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    let tmp_9_0;
    const config_r7 = \u0275\u0275nextContext(3).$implicit;
    const ctx_r2 = \u0275\u0275nextContext(3);
    \u0275\u0275advance();
    \u0275\u0275property("src", ctx_r2.apiUrl + "/" + ((tmp_9_0 = config_r7.get("config_value")) == null ? null : tmp_9_0.value), \u0275\u0275sanitizeUrl);
  }
}
function UserConfigurationComponent_ng_container_22_div_1_ng_container_15_tr_1_ng_container_7_Template(rf, ctx) {
  if (rf & 1) {
    const _r6 = \u0275\u0275getCurrentView();
    \u0275\u0275elementContainerStart(0);
    \u0275\u0275elementStart(1, "div", 33);
    \u0275\u0275template(2, UserConfigurationComponent_ng_container_22_div_1_ng_container_15_tr_1_ng_container_7_div_2_Template, 2, 1, "div", 34);
    \u0275\u0275elementStart(3, "input", 35);
    \u0275\u0275listener("change", function UserConfigurationComponent_ng_container_22_div_1_ng_container_15_tr_1_ng_container_7_Template_input_change_3_listener($event) {
      \u0275\u0275restoreView(_r6);
      const i_r8 = \u0275\u0275nextContext(2).index;
      const tab_r9 = \u0275\u0275nextContext(2).$implicit;
      const ctx_r2 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r2.onFileChange($event, tab_r9.name, i_r8));
    });
    \u0275\u0275elementEnd()();
    \u0275\u0275elementContainerEnd();
  }
  if (rf & 2) {
    let tmp_8_0;
    const config_r7 = \u0275\u0275nextContext(2).$implicit;
    \u0275\u0275advance(2);
    \u0275\u0275property("ngIf", (tmp_8_0 = config_r7.get("config_value")) == null ? null : tmp_8_0.value);
  }
}
function UserConfigurationComponent_ng_container_22_div_1_ng_container_15_tr_1_ng_container_8_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementContainerStart(0);
    \u0275\u0275element(1, "input", 38);
    \u0275\u0275elementContainerEnd();
  }
}
function UserConfigurationComponent_ng_container_22_div_1_ng_container_15_tr_1_ng_container_9_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementContainerStart(0);
    \u0275\u0275element(1, "input", 39);
    \u0275\u0275elementContainerEnd();
  }
}
function UserConfigurationComponent_ng_container_22_div_1_ng_container_15_tr_1_ng_container_10_ng_container_2_Template(rf, ctx) {
  if (rf & 1) {
    const _r10 = \u0275\u0275getCurrentView();
    \u0275\u0275elementContainerStart(0);
    \u0275\u0275element(1, "ng-select", 42);
    \u0275\u0275elementStart(2, "button", 43);
    \u0275\u0275listener("click", function UserConfigurationComponent_ng_container_22_div_1_ng_container_15_tr_1_ng_container_10_ng_container_2_Template_button_click_2_listener() {
      \u0275\u0275restoreView(_r10);
      const i_r8 = \u0275\u0275nextContext(3).index;
      const ctx_r2 = \u0275\u0275nextContext(3);
      return \u0275\u0275resetView(ctx_r2.openJsonEditor(i_r8));
    });
    \u0275\u0275element(3, "i", 44);
    \u0275\u0275elementEnd();
    \u0275\u0275elementContainerEnd();
  }
  if (rf & 2) {
    const config_r7 = \u0275\u0275nextContext(3).$implicit;
    const ctx_r2 = \u0275\u0275nextContext(3);
    \u0275\u0275advance();
    \u0275\u0275property("items", ctx_r2.getSelectOptions(config_r7))("multiple", false);
  }
}
function UserConfigurationComponent_ng_container_22_div_1_ng_container_15_tr_1_ng_container_10_ng_container_3_Template(rf, ctx) {
  if (rf & 1) {
    const _r11 = \u0275\u0275getCurrentView();
    \u0275\u0275elementContainerStart(0);
    \u0275\u0275element(1, "textarea", 45);
    \u0275\u0275elementStart(2, "button", 46);
    \u0275\u0275listener("click", function UserConfigurationComponent_ng_container_22_div_1_ng_container_15_tr_1_ng_container_10_ng_container_3_Template_button_click_2_listener() {
      \u0275\u0275restoreView(_r11);
      const ctx_r11 = \u0275\u0275nextContext(3);
      const config_r7 = ctx_r11.$implicit;
      const i_r8 = ctx_r11.index;
      const ctx_r2 = \u0275\u0275nextContext(3);
      return \u0275\u0275resetView(ctx_r2.applyJson(i_r8, config_r7));
    });
    \u0275\u0275element(3, "i", 47);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(4, "button", 48);
    \u0275\u0275listener("click", function UserConfigurationComponent_ng_container_22_div_1_ng_container_15_tr_1_ng_container_10_ng_container_3_Template_button_click_4_listener() {
      \u0275\u0275restoreView(_r11);
      const i_r8 = \u0275\u0275nextContext(3).index;
      const ctx_r2 = \u0275\u0275nextContext(3);
      return \u0275\u0275resetView(ctx_r2.jsonEditorOpen[i_r8] = false);
    });
    \u0275\u0275element(5, "i", 49);
    \u0275\u0275elementEnd();
    \u0275\u0275elementContainerEnd();
  }
}
function UserConfigurationComponent_ng_container_22_div_1_ng_container_15_tr_1_ng_container_10_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementContainerStart(0);
    \u0275\u0275elementStart(1, "div", 40);
    \u0275\u0275template(2, UserConfigurationComponent_ng_container_22_div_1_ng_container_15_tr_1_ng_container_10_ng_container_2_Template, 4, 2, "ng-container", 41)(3, UserConfigurationComponent_ng_container_22_div_1_ng_container_15_tr_1_ng_container_10_ng_container_3_Template, 6, 0, "ng-container", 41);
    \u0275\u0275elementEnd();
    \u0275\u0275elementContainerEnd();
  }
  if (rf & 2) {
    const i_r8 = \u0275\u0275nextContext(2).index;
    const ctx_r2 = \u0275\u0275nextContext(3);
    \u0275\u0275advance(2);
    \u0275\u0275property("ngIf", !ctx_r2.jsonEditorOpen[i_r8]);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx_r2.jsonEditorOpen[i_r8]);
  }
}
function UserConfigurationComponent_ng_container_22_div_1_ng_container_15_tr_1_ng_container_11_ng_container_2_Template(rf, ctx) {
  if (rf & 1) {
    const _r13 = \u0275\u0275getCurrentView();
    \u0275\u0275elementContainerStart(0);
    \u0275\u0275element(1, "ng-select", 42);
    \u0275\u0275elementStart(2, "button", 43);
    \u0275\u0275listener("click", function UserConfigurationComponent_ng_container_22_div_1_ng_container_15_tr_1_ng_container_11_ng_container_2_Template_button_click_2_listener() {
      \u0275\u0275restoreView(_r13);
      const i_r8 = \u0275\u0275nextContext(3).index;
      const ctx_r2 = \u0275\u0275nextContext(3);
      return \u0275\u0275resetView(ctx_r2.openJsonEditor(i_r8));
    });
    \u0275\u0275element(3, "i", 44);
    \u0275\u0275elementEnd();
    \u0275\u0275elementContainerEnd();
  }
  if (rf & 2) {
    const config_r7 = \u0275\u0275nextContext(3).$implicit;
    const ctx_r2 = \u0275\u0275nextContext(3);
    \u0275\u0275advance();
    \u0275\u0275property("items", ctx_r2.getSelectOptions(config_r7))("multiple", true);
  }
}
function UserConfigurationComponent_ng_container_22_div_1_ng_container_15_tr_1_ng_container_11_ng_container_3_Template(rf, ctx) {
  if (rf & 1) {
    const _r14 = \u0275\u0275getCurrentView();
    \u0275\u0275elementContainerStart(0);
    \u0275\u0275element(1, "textarea", 45);
    \u0275\u0275elementStart(2, "button", 46);
    \u0275\u0275listener("click", function UserConfigurationComponent_ng_container_22_div_1_ng_container_15_tr_1_ng_container_11_ng_container_3_Template_button_click_2_listener() {
      \u0275\u0275restoreView(_r14);
      const ctx_r11 = \u0275\u0275nextContext(3);
      const config_r7 = ctx_r11.$implicit;
      const i_r8 = ctx_r11.index;
      const ctx_r2 = \u0275\u0275nextContext(3);
      return \u0275\u0275resetView(ctx_r2.applyJson(i_r8, config_r7));
    });
    \u0275\u0275element(3, "i", 47);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(4, "button", 48);
    \u0275\u0275listener("click", function UserConfigurationComponent_ng_container_22_div_1_ng_container_15_tr_1_ng_container_11_ng_container_3_Template_button_click_4_listener() {
      \u0275\u0275restoreView(_r14);
      const i_r8 = \u0275\u0275nextContext(3).index;
      const ctx_r2 = \u0275\u0275nextContext(3);
      return \u0275\u0275resetView(ctx_r2.jsonEditorOpen[i_r8] = false);
    });
    \u0275\u0275element(5, "i", 49);
    \u0275\u0275elementEnd();
    \u0275\u0275elementContainerEnd();
  }
}
function UserConfigurationComponent_ng_container_22_div_1_ng_container_15_tr_1_ng_container_11_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementContainerStart(0);
    \u0275\u0275elementStart(1, "div", 40);
    \u0275\u0275template(2, UserConfigurationComponent_ng_container_22_div_1_ng_container_15_tr_1_ng_container_11_ng_container_2_Template, 4, 2, "ng-container", 41)(3, UserConfigurationComponent_ng_container_22_div_1_ng_container_15_tr_1_ng_container_11_ng_container_3_Template, 6, 0, "ng-container", 41);
    \u0275\u0275elementEnd();
    \u0275\u0275elementContainerEnd();
  }
  if (rf & 2) {
    const i_r8 = \u0275\u0275nextContext(2).index;
    const ctx_r2 = \u0275\u0275nextContext(3);
    \u0275\u0275advance(2);
    \u0275\u0275property("ngIf", !ctx_r2.jsonEditorOpen[i_r8]);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx_r2.jsonEditorOpen[i_r8]);
  }
}
function UserConfigurationComponent_ng_container_22_div_1_ng_container_15_tr_1_ng_container_12_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementContainerStart(0);
    \u0275\u0275element(1, "input", 50);
    \u0275\u0275elementContainerEnd();
  }
}
function UserConfigurationComponent_ng_container_22_div_1_ng_container_15_tr_1_ng_container_13_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementContainerStart(0);
    \u0275\u0275element(1, "ng-select", 51);
    \u0275\u0275elementContainerEnd();
  }
  if (rf & 2) {
    const ctx_r2 = \u0275\u0275nextContext(5);
    \u0275\u0275advance();
    \u0275\u0275property("items", ctx_r2.timezoneList)("searchable", true);
  }
}
function UserConfigurationComponent_ng_container_22_div_1_ng_container_15_tr_1_ng_container_14_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementContainerStart(0);
    \u0275\u0275element(1, "ng-select", 52);
    \u0275\u0275elementContainerEnd();
  }
  if (rf & 2) {
    const ctx_r2 = \u0275\u0275nextContext(5);
    \u0275\u0275advance();
    \u0275\u0275property("items", ctx_r2.datetimeFormatList)("searchable", true);
  }
}
function UserConfigurationComponent_ng_container_22_div_1_ng_container_15_tr_1_Template(rf, ctx) {
  if (rf & 1) {
    const _r5 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "tr", 18)(1, "td", 25)(2, "input", 26);
    \u0275\u0275listener("keydown", function UserConfigurationComponent_ng_container_22_div_1_ng_container_15_tr_1_Template_input_keydown_2_listener($event) {
      \u0275\u0275restoreView(_r5);
      const ctx_r2 = \u0275\u0275nextContext(4);
      return \u0275\u0275resetView(ctx_r2.localStorageService.handleKeyPress($event, { type: ctx_r2.commonConfig.keypress_config.allow_only_lowercase_alphanumeric }));
    });
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(3, "td", 25);
    \u0275\u0275elementContainerStart(4, 27);
    \u0275\u0275template(5, UserConfigurationComponent_ng_container_22_div_1_ng_container_15_tr_1_ng_container_5_Template, 2, 0, "ng-container", 28)(6, UserConfigurationComponent_ng_container_22_div_1_ng_container_15_tr_1_ng_container_6_Template, 2, 0, "ng-container", 28)(7, UserConfigurationComponent_ng_container_22_div_1_ng_container_15_tr_1_ng_container_7_Template, 4, 1, "ng-container", 28)(8, UserConfigurationComponent_ng_container_22_div_1_ng_container_15_tr_1_ng_container_8_Template, 2, 0, "ng-container", 28)(9, UserConfigurationComponent_ng_container_22_div_1_ng_container_15_tr_1_ng_container_9_Template, 2, 0, "ng-container", 28)(10, UserConfigurationComponent_ng_container_22_div_1_ng_container_15_tr_1_ng_container_10_Template, 4, 2, "ng-container", 28)(11, UserConfigurationComponent_ng_container_22_div_1_ng_container_15_tr_1_ng_container_11_Template, 4, 2, "ng-container", 28)(12, UserConfigurationComponent_ng_container_22_div_1_ng_container_15_tr_1_ng_container_12_Template, 2, 0, "ng-container", 28)(13, UserConfigurationComponent_ng_container_22_div_1_ng_container_15_tr_1_ng_container_13_Template, 2, 2, "ng-container", 28)(14, UserConfigurationComponent_ng_container_22_div_1_ng_container_15_tr_1_ng_container_14_Template, 2, 2, "ng-container", 28);
    \u0275\u0275elementContainerEnd();
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(15, "td", 25)(16, "button", 29);
    \u0275\u0275listener("click", function UserConfigurationComponent_ng_container_22_div_1_ng_container_15_tr_1_Template_button_click_16_listener() {
      \u0275\u0275restoreView(_r5);
      const i_r8 = \u0275\u0275nextContext().index;
      const tab_r9 = \u0275\u0275nextContext(2).$implicit;
      const ctx_r2 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r2.removeItem(tab_r9.name, i_r8));
    });
    \u0275\u0275element(17, "i", 30);
    \u0275\u0275elementEnd()()();
  }
  if (rf & 2) {
    let tmp_9_0;
    const ctx_r11 = \u0275\u0275nextContext();
    const config_r7 = ctx_r11.$implicit;
    const i_r8 = ctx_r11.index;
    const ctx_r2 = \u0275\u0275nextContext(3);
    \u0275\u0275property("formGroupName", i_r8);
    \u0275\u0275advance(2);
    \u0275\u0275property("ngClass", \u0275\u0275pureFunction1(13, _c2, !(ctx_r2.masterInfo == null ? null : ctx_r2.masterInfo.permissions == null ? null : ctx_r2.masterInfo.permissions.edit)));
    \u0275\u0275advance(2);
    \u0275\u0275property("ngSwitch", (tmp_9_0 = config_r7.get("config_field_type")) == null ? null : tmp_9_0.value);
    \u0275\u0275advance();
    \u0275\u0275property("ngSwitchCase", "text");
    \u0275\u0275advance();
    \u0275\u0275property("ngSwitchCase", "date");
    \u0275\u0275advance();
    \u0275\u0275property("ngSwitchCase", "file");
    \u0275\u0275advance();
    \u0275\u0275property("ngSwitchCase", "number");
    \u0275\u0275advance();
    \u0275\u0275property("ngSwitchCase", "checkbox");
    \u0275\u0275advance();
    \u0275\u0275property("ngSwitchCase", "single_select");
    \u0275\u0275advance();
    \u0275\u0275property("ngSwitchCase", "multiselect");
    \u0275\u0275advance();
    \u0275\u0275property("ngSwitchCase", "time");
    \u0275\u0275advance();
    \u0275\u0275property("ngSwitchCase", "timezone");
    \u0275\u0275advance();
    \u0275\u0275property("ngSwitchCase", "datetimeformat");
  }
}
function UserConfigurationComponent_ng_container_22_div_1_ng_container_15_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementContainerStart(0);
    \u0275\u0275template(1, UserConfigurationComponent_ng_container_22_div_1_ng_container_15_tr_1_Template, 18, 15, "tr", 17);
    \u0275\u0275elementContainerEnd();
  }
  if (rf & 2) {
    let tmp_6_0;
    const config_r7 = ctx.$implicit;
    const ctx_r2 = \u0275\u0275nextContext(3);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", (ctx_r2.masterInfo == null ? null : ctx_r2.masterInfo.permissions == null ? null : ctx_r2.masterInfo.permissions.edit) || ((tmp_6_0 = config_r7.get("display_config")) == null ? null : tmp_6_0.value));
  }
}
function UserConfigurationComponent_ng_container_22_div_1_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 18);
    \u0275\u0275elementContainerStart(1, 19);
    \u0275\u0275elementStart(2, "table", 20)(3, "thead", 21)(4, "tr")(5, "th", 22);
    \u0275\u0275text(6);
    \u0275\u0275pipe(7, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(8, "th", 22);
    \u0275\u0275text(9);
    \u0275\u0275pipe(10, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(11, "th", 23);
    \u0275\u0275text(12);
    \u0275\u0275pipe(13, "translate");
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(14, "tbody", 24);
    \u0275\u0275template(15, UserConfigurationComponent_ng_container_22_div_1_ng_container_15_Template, 2, 1, "ng-container", 14);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementContainerEnd();
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const tab_r9 = \u0275\u0275nextContext().$implicit;
    const ctx_r2 = \u0275\u0275nextContext();
    \u0275\u0275property("formGroupName", tab_r9.name);
    \u0275\u0275advance(6);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(7, 5, "config_table_field_label"), " ");
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(10, 7, "config_table_field_value"), " ");
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(13, 9, "table_action"), " ");
    \u0275\u0275advance(3);
    \u0275\u0275property("ngForOf", ctx_r2.getConfigurationsArray(tab_r9.name).controls);
  }
}
function UserConfigurationComponent_ng_container_22_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementContainerStart(0);
    \u0275\u0275template(1, UserConfigurationComponent_ng_container_22_div_1_Template, 16, 11, "div", 17);
    \u0275\u0275elementContainerEnd();
  }
  if (rf & 2) {
    const tab_r9 = ctx.$implicit;
    const ctx_r2 = \u0275\u0275nextContext();
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx_r2.currentTab == tab_r9.name);
  }
}
function UserConfigurationComponent_div_23_option_12_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "option", 69);
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const tab_r16 = ctx.$implicit;
    \u0275\u0275property("value", tab_r16.category_id + "_" + tab_r16.name);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate(tab_r16.name);
  }
}
function UserConfigurationComponent_div_23_Template(rf, ctx) {
  if (rf & 1) {
    const _r15 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 53)(1, "div", 54)(2, "span");
    \u0275\u0275text(3);
    \u0275\u0275pipe(4, "translate");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(5, "form", 55);
    \u0275\u0275listener("ngSubmit", function UserConfigurationComponent_div_23_Template_form_ngSubmit_5_listener() {
      \u0275\u0275restoreView(_r15);
      const ctx_r2 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r2.onSubmitNewConfig());
    });
    \u0275\u0275elementStart(6, "ng-scrollbar", 56)(7, "div", 57)(8, "label", 58);
    \u0275\u0275text(9);
    \u0275\u0275pipe(10, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(11, "select", 59);
    \u0275\u0275template(12, UserConfigurationComponent_div_23_option_12_Template, 2, 2, "option", 60);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(13, "div", 57)(14, "label", 61);
    \u0275\u0275text(15);
    \u0275\u0275pipe(16, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(17, "input", 62);
    \u0275\u0275listener("keydown", function UserConfigurationComponent_div_23_Template_input_keydown_17_listener($event) {
      \u0275\u0275restoreView(_r15);
      const ctx_r2 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r2.localStorageService.handleKeyPress($event, { type: ctx_r2.commonConfig.keypress_config.allow_only_lowercase_alphanumeric }));
    });
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(18, "div", 57)(19, "label", 63);
    \u0275\u0275text(20);
    \u0275\u0275pipe(21, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275element(22, "input", 64);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(23, "div", 65)(24, "div", 66)(25, "button", 67);
    \u0275\u0275text(26);
    \u0275\u0275pipe(27, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(28, "button", 68);
    \u0275\u0275listener("click", function UserConfigurationComponent_div_23_Template_button_click_28_listener() {
      \u0275\u0275restoreView(_r15);
      const ctx_r2 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r2.toggleMenu());
    });
    \u0275\u0275text(29);
    \u0275\u0275pipe(30, "translate");
    \u0275\u0275elementEnd()()()()();
  }
  if (rf & 2) {
    const ctx_r2 = \u0275\u0275nextContext();
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(4, 8, "add_new_records"));
    \u0275\u0275advance(2);
    \u0275\u0275property("formGroup", ctx_r2.newConfigForm);
    \u0275\u0275advance(4);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(10, 10, "config_table_field_category"));
    \u0275\u0275advance(3);
    \u0275\u0275property("ngForOf", ctx_r2.tabs);
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(16, 12, "config_table_field_label"));
    \u0275\u0275advance(5);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(21, 14, "config_table_field_value"));
    \u0275\u0275advance(6);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(27, 16, "submit"), " ");
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(30, 18, "cancel"), " ");
  }
}
var DATETIME_FORMAT_LIST = [
  { value: "yyyy-MM-dd HH:mm:ss", label: "yyyy-MM-dd HH:mm:ss" },
  { value: "MMM dd, yyyy HH:mm", label: "MMM dd, yyyy HH:mm" },
  { value: "dd/MM/yyyy HH:mm:ss", label: "dd/MM/yyyy HH:mm:ss" },
  { value: "MM/dd/yyyy h:mm a", label: "MM/dd/yyyy h:mm a" },
  { value: "EEEE, MMMM dd, yyyy", label: "EEEE, MMMM dd, yyyy" },
  { value: "yyyy-MM-dd'T'HH:mm:ss.SSSZ", label: "yyyy-MM-dd'T'HH:mm:ss.SSSZ" }
];
var _UserConfigurationComponent = class _UserConfigurationComponent {
  constructor(commonService, route, storeData, gridApiService, localStorageService, fb, translate, toastr, router, titleService, cdr) {
    this.commonService = commonService;
    this.route = route;
    this.storeData = storeData;
    this.gridApiService = gridApiService;
    this.localStorageService = localStorageService;
    this.fb = fb;
    this.translate = translate;
    this.toastr = toastr;
    this.router = router;
    this.titleService = titleService;
    this.cdr = cdr;
    this.userId = null;
    this.companyId = null;
    this.tabs = [];
    this.currentTab = "";
    this.title_key = "configuration";
    this.isMenuOpen = false;
    this.userList = [];
    this.selectedUserId = null;
    this.gridpaginationdropdownList = ["5", "10", "15", "20", "25", "30", "40", "50", "60", "70", "80", "90", "100"];
    this.fieldTypeOptions = ["text", "number", "date", "checkbox", "file", "multiselect", "single_select", "time", "timezone", "datetimeformat"];
    this.valueTypeOptions = ["static"];
    this.update_json_schema = {
      print_query: true,
      action: ["update", "insert"],
      table: ["app_user_configurations", "app_user_configurations"],
      table_mapping: ["table1", "table2"],
      data: {
        table2: []
      },
      conditions: {
        table1: []
      }
    };
    this.insert_particular_schema = {
      print_query: true,
      action: ["insert"],
      table: ["app_user_configurations"],
      table_mapping: ["table1"],
      data: {
        table1: []
      },
      conditions: {}
    };
    this.delete_json_schema = {
      // it will be removed
      action: ["hard_delete"],
      table: ["app_user_configurations"],
      table_mapping: ["table1"],
      conditions: {
        table1: []
      }
    };
    this.commonConfig = commonConfig;
    this.apiUrl = environment.apiUrl;
    this.timezoneList = TIMEZONE_LIST;
    this.datetimeFormatList = DATETIME_FORMAT_LIST;
    this.jsonEditorOpen = {};
    this.jsonEditorOpenNew = false;
    this.disableuser = true;
    this.allTabsForm = this.fb.group({});
    this.configForm = this.fb.group({
      configurations: this.fb.array([])
    });
    this.newConfigForm = this.fb.group({
      tab: ["", Validators.required],
      key: ["", Validators.required],
      value: [""]
    });
    this.userList = [];
    this.selectedUserId = null;
    this.initStore();
  }
  ngOnInit() {
    this.title_key = this.route.snapshot.data["pageInfo"].fullEntity;
    const translateTitle = this.translate.instant(this.title_key);
    this.titleService.setTitle(translateTitle);
    const userData = this.localStorageService.getData("user_data");
    if (userData) {
      const parsedData = JSON.parse(userData);
      this.userId = parsedData.main?.id;
      this.selectedUserId = this.userId;
      this.selectedUserRole = parsedData.main?.role;
      console.log(this.selectedUserRole);
      if (this.selectedUserRole == "super_admin" || this.selectedUserRole == "company_admin") {
        this.disableuser = false;
      } else {
        this.disableuser = true;
      }
      this.companyId = parsedData.main?.company_id;
    }
    const pageInfo = this.route.snapshot.data["pageInfo"] || "";
    if (pageInfo) {
      this.masterInfo = pageInfo;
    }
    this.initializeUserData();
    this.loadAllItems("act5");
    this.getUserList();
  }
  updateValueField(keyType) {
    const valueControl = this.newConfigForm.get("value");
    if (valueControl) {
      switch (keyType) {
        case "text":
        case "number":
        case "date":
        case "time":
          valueControl.setValidators([Validators.required]);
          break;
        case "file":
        case "checkbox":
        case "single_select":
        case "multiselect":
          valueControl.clearValidators();
          break;
        default:
          valueControl.clearValidators();
      }
      valueControl.updateValueAndValidity();
    }
  }
  initStore() {
    return __async(this, null, function* () {
      this.storeData.select((d) => d.index).subscribe((d) => {
        this.store = d;
      });
    });
  }
  initializeUserData() {
    const userData = this.localStorageService.getData("user_data");
    if (userData) {
      const parsedData = JSON.parse(userData);
      this.userId = parsedData.main?.id;
      this.companyId = parsedData.main?.company_id;
    }
  }
  addNewItemFormArray(isFirstTime) {
    console.log(isFirstTime);
  }
  prepareNewRecords() {
    console.log("working");
  }
  toggleMenu() {
    this.isMenuOpen = !this.isMenuOpen;
    if (this.isMenuOpen)
      this.addNewItemFormArray(true);
  }
  getTabByName(tabName) {
    return this.allTabsForm.get(tabName);
  }
  loadAllItems(appCategoryTypeId) {
    console.log(this.selectedUserId);
    if (!this.companyId) {
      console.error("Company ID is not available");
      return;
    }
    const search_all = [
      {
        column_name: "app_categories.category_type_id",
        value: appCategoryTypeId,
        operator: "="
      },
      {
        column_name: "app_categories.status_id",
        value: 1,
        operator: "="
      }
    ];
    let appcondition = `app_categories.category_id = app_user_configurations.category_id`;
    if (this.selectedUserId) {
      appcondition += ` AND app_user_configurations.user_id = ` + this.selectedUserId;
    }
    const payload = {
      company_id: this.companyId,
      print_query: true,
      primary_table: "app_categories",
      start_index: 0,
      limit_range: 100,
      sort_columns: [["app_categories.id", "asc"]],
      search_all,
      select_columns: [
        ["app_categories.*"],
        [
          "CASE WHEN COUNT(app_user_configurations.id) = 0 THEN null ELSE COALESCE(Json_agg(DISTINCT jsonb_build_object('id', app_user_configurations.id,'display_config',app_user_configurations.display_config,'order_no',app_user_configurations.order_no,'config_key', app_user_configurations.config_key,'category_id', app_user_configurations.category_id,'config_value', app_user_configurations.config_value,'config_file_value', app_user_configurations.config_file_value,'config_value_type', app_user_configurations.config_value_type,'config_field_type', app_user_configurations.config_field_type,'config_select_json',app_user_configurations.config_select_json))) END",
          "configurations"
        ]
      ],
      includes: [
        {
          table_name: "app_user_configurations",
          join_type: "LEFT",
          join_condition: appcondition
        }
      ],
      group_by: ["app_categories.id"]
    };
    this.gridApiService.getAllList(payload).subscribe({
      next: (response) => {
        if (response.code === 200 && response.status) {
          this.tabs = response.data.records;
          let commonTabs = [];
          this.tabs.map(function(ielem) {
            if (ielem.configurations) {
              commonTabs.push(...ielem.configurations);
            }
          });
          this.tabs.map(function(ielem) {
            if (ielem.configurations) {
              ielem.configurations.map(function(elem) {
                if (elem.config_field_type == "multiselect" || elem.config_field_type == "single_select") {
                  try {
                    let options = [];
                    if (elem.config_select_json) {
                      options = JSON.parse(typeof elem.config_select_json === "string" ? elem.config_select_json : JSON.stringify(elem.config_select_json));
                    }
                    const idType = options.length > 0 && typeof options[0].id === "number" ? "number" : "string";
                    let values = elem.config_value ? elem.config_value.split(",").map((v) => {
                      if (idType === "number") {
                        const n = Number(v);
                        return isNaN(n) ? v : n;
                      }
                      return v;
                    }) : [];
                    if (elem.config_field_type == "single_select") {
                      elem.config_value = values.length > 0 ? values[0] : null;
                    } else {
                      elem.config_value = values;
                    }
                  } catch {
                    elem.config_value = elem.config_field_type == "multiselect" ? [] : null;
                  }
                }
                if (elem.config_field_type == "checkbox") {
                  elem.config_value = elem.config_value == "true" && true;
                }
              });
            }
          });
          if (this.tabs.length > 0) {
            this.newConfigForm.get("tab")?.setValue(this.tabs[0].category_id + "_" + this.tabs[0].name);
          }
          this.initAllTabsForms();
          if (this.tabs.length > 0) {
            this.switchTab(this.currentTab?.length ? this.currentTab : this.tabs[0].name);
          }
        }
      },
      error: (error) => {
        const key = "error";
        const errorMessage = this.translate.instant(key);
        this.toastr.error(errorMessage, "Error");
        console.error("Error fetching entity types:", error);
      }
    });
  }
  reloadCurrentPage() {
    this.router.navigate([this.router.url]).then(() => {
      window.location.reload();
    });
  }
  getconfig() {
    const procedureParams = { proc_name: "get_configurations_values_v1", params: { categories: { "0": "ac16", "1": "ac17" } } };
    this.commonService.unAuthProcedureCall(procedureParams).subscribe({
      next: (response) => {
        if (response.code === 200 && response.status && response.data) {
          const res = response.data?.[0]?.result?.data || [];
          if (Object.keys(res).length > 0) {
            localStorage.setItem("config", JSON.stringify(res));
            this.reloadCurrentPage();
          }
        } else {
          const key = "error";
          const errorMessage = this.translate.instant(key);
          this.toastr.error(errorMessage, "Error");
          console.log(response.message);
        }
      },
      error: (error) => {
        console.error("Error fetching data:", error);
      },
      complete: () => {
      }
    });
  }
  initAllTabsForms() {
    console.log("coming");
    this.tabs.forEach((tab) => {
      this.allTabsForm.addControl(tab.name, this.fb.group({
        configurations: this.fb.array([])
      }));
      this.initFormForTab(tab);
    });
  }
  initFormForTab(tab) {
    const configurationsArray = this.allTabsForm.get(tab.name)?.get("configurations");
    configurationsArray.clear();
    if (tab.configurations) {
      tab.configurations.forEach((config) => {
        const fg = this.createConfigFormGroup(config);
        if (config.config_field_type === "multiselect" || config.config_field_type === "single_select") {
          fg.get("config_value")?.enable();
        }
        configurationsArray.push(fg);
      });
    }
    this.cdr.detectChanges();
  }
  createConfigFormGroup(config) {
    let selectOptions = [];
    if (config.config_field_type === "multiselect" || config.config_field_type === "single_select") {
      try {
        selectOptions = config.config_select_json ? JSON.parse(typeof config.config_select_json === "string" ? config.config_select_json : JSON.stringify(config.config_select_json)) : [];
      } catch {
        selectOptions = [];
      }
    }
    const fg = this.fb.group({
      id: [config.id],
      config_key: [config.config_key, Validators.required],
      category_id: [config.category_id],
      config_value: [config.config_value],
      config_select_json: [
        config.config_select_json ? typeof config.config_select_json === "string" ? config.config_select_json : JSON.stringify(config.config_select_json, null, 2) : ""
      ],
      order_no: [config.order_no],
      config_value_type: [config.config_value_type, Validators.required],
      config_field_type: [config.config_field_type, Validators.required],
      display_config: [config.display_config, Validators.required]
    });
    fg._selectOptions = selectOptions;
    return fg;
  }
  get configurationsArray() {
    return this.configForm.get("configurations");
  }
  get currentTabConfigurationsArray() {
    return this.allTabsForm.get(this.currentTab)?.get("configurations");
  }
  getConfigurationsArray(tabName) {
    const configurations = this.allTabsForm.get(tabName)?.get("configurations");
    configurations.controls.sort((a, b) => {
      const orderA = a.get("order_no")?.value || 0;
      const orderB = b.get("order_no")?.value || 0;
      return orderA - orderB;
    });
    return configurations;
  }
  onFileChange(event, tabName, index) {
    const inputElement = event.target;
    if (inputElement.files && inputElement.files.length > 0) {
      const pic = inputElement.files[0];
      this.gridApiService.uploadConfigPicture(pic).subscribe((response) => {
        if (response.body && response.body.status) {
          const docNames = response.body.data;
          const configurationsArray = this.allTabsForm.get(tabName)?.get("configurations");
          const configControl = configurationsArray.at(index);
          configControl.patchValue({ config_value: docNames });
        }
      }, (error) => {
        const key = "error";
        const errorMessage = this.translate.instant(key);
        this.toastr.error(errorMessage, "Error");
      });
    }
  }
  removeItem(tabName, index) {
    const configurationsArray = this.allTabsForm.get(tabName)?.get("configurations");
    const configControl = configurationsArray.at(index);
    const id = configControl.get("id")?.value;
    import_sweetalert2.default.fire({
      icon: "warning",
      title: "Are you sure?",
      text: "You won't be able to revert this!",
      showCancelButton: true,
      confirmButtonText: "Delete",
      padding: "2em"
    }).then((result) => __async(this, null, function* () {
      if (result.value) {
        try {
          this.deleteRecords(id);
        } catch (error) {
          const key = "error";
          const errorMessage = this.translate.instant(key);
          this.toastr.error(errorMessage, error.message);
        }
      }
    }));
  }
  deleteRecords(id) {
    this.delete_json_schema.conditions["table1"] = [{ id }];
    this.gridApiService.executeRecords(this.delete_json_schema).subscribe((response) => {
      if (response.status && response.code === 200) {
        const key = "record_deleted_successfully";
        const successMessage = this.translate.instant(key);
        this.toastr.success(successMessage);
        this.loadAllItems("act5");
      } else {
        const key = "record_failed_deleted";
        const errorMessage = this.translate.instant(key);
        this.toastr.error(errorMessage, "Error");
      }
    }, (error) => {
      const key = "record_failed_deleted";
      const errorMessage = this.translate.instant(key);
      this.toastr.error(errorMessage, "Error");
    });
  }
  saveChanges() {
    let hasInvalidJson = false;
    Object.keys(this.allTabsForm.controls).forEach((tabName) => {
      const configs = this.allTabsForm.get(tabName)?.get("configurations")?.value;
      if (configs) {
        configs.forEach((cfg) => {
          if ((cfg.config_field_type === "multiselect" || cfg.config_field_type === "single_select") && !this.isValidJson(cfg.config_select_json)) {
            hasInvalidJson = true;
          }
        });
      }
    });
    if (hasInvalidJson) {
      this.toastr.error("Invalid JSON in select options. Please fix before saving.", "Error");
      return;
    }
    if (this.allTabsForm.valid) {
      const allConfigurations = {};
      const postData = [];
      Object.keys(this.allTabsForm.controls).forEach((tabName) => {
        allConfigurations[tabName] = this.allTabsForm.get(tabName)?.get("configurations")?.value;
        postData.push(...this.allTabsForm.get(tabName)?.get("configurations")?.value);
      });
      const updateItems = postData.filter((item) => item.id);
      const insertItems = postData.filter((item) => !item.id);
      const update_conds = updateItems.map((item) => ({
        id: item.id
      }));
      updateItems.map(function(elem) {
        if (elem.config_field_type == "multiselect" || elem.config_field_type == "single_select") {
          elem.config_value = elem.config_value.toString();
        }
      });
      insertItems.map(function(elem) {
        if (elem.config_field_type == "multiselect" || elem.config_field_type == "single_select") {
          elem.config_value = elem.config_value.toString();
        }
      });
      const fixConfigSelectJson = (item) => {
        if (item.config_select_json === "" || item.config_select_json == null) {
          item.config_select_json = null;
        }
        return item;
      };
      updateItems.forEach(fixConfigSelectJson);
      insertItems.forEach(fixConfigSelectJson);
      this.update_json_schema.conditions["table1"] = update_conds;
      this.update_json_schema.data["table1"] = updateItems;
      this.update_json_schema.data["table2"] = insertItems;
      this.gridApiService.executeRecords(this.update_json_schema).subscribe((response) => {
        if (response.status && response.code === 200) {
          const key = "record_updated_successfully";
          const successMessage = this.translate.instant(key);
          this.toastr.success(successMessage);
          this.loadAllItems("act5");
        } else {
          const key = "record_failed_updated";
          const errorMessage = this.translate.instant(key);
          this.toastr.error(errorMessage, "Error");
        }
      }, (error) => {
        const key = "record_failed_inserted";
        const errorMessage = this.translate.instant(key);
        this.toastr.error(errorMessage, "Error");
      });
    } else {
      console.log("Form is invalid");
    }
  }
  getUserList() {
    let search_all = [
      {
        column_name: "users.status_id",
        value: "1",
        operator: "="
      }
    ];
    if (this.selectedUserRole != "super_admin") {
      search_all.push({
        "value": [
          "super_admin",
          "company_admin"
        ],
        "operator": "NOT IN",
        "column_name": "users.role"
      });
    }
    const param = {
      company_id: 1,
      print_query: false,
      primary_table: "users",
      start_index: 0,
      limit_range: 1e3,
      sort_columns: [["concat(user_details.first_name, ' ', user_details.last_name)", "asc"]],
      search_all,
      includes: [
        {
          table_name: "user_details",
          join_type: "INNER",
          join_condition: "users.id = user_details.user_id"
        },
        {
          table_name: "organizations",
          join_type: "LEFT",
          join_condition: "organizations.id = user_details.organization_id"
        }
      ],
      select_columns: [["users.id"], ["concat(user_details.first_name, ' ', user_details.last_name)", "name"], ["users.uuid"], ["organizations.name", "org_name"]]
    };
    this.gridApiService.getListData(param).subscribe((response) => {
      if (response.status) {
        this.userList = response.data?.records || [];
        if (this.userList.length > 0) {
          if (typeof this.selectedUserId === "number") {
            this.onUserSelect(this.selectedUserId);
          }
        }
      } else if (!response.status) {
        this.userList = [];
        const key = response.message;
        const errorMessage = this.translate.instant(key);
        this.toastr.error(`Code: ${response.code} , ${errorMessage}`);
      }
    }, (error) => {
      this.userList = [];
      const key = "error";
      const errorMessage = this.translate.instant(key);
      this.toastr.error(errorMessage, "Error");
    });
  }
  onUserSelect(userId) {
    this.selectedUserId = userId;
    this.loadAllItems("act5");
  }
  onSubmitNewConfig() {
    const newConfig = this.newConfigForm.value;
    console.log(newConfig);
    if ((newConfig.keyType === "multiselect" || newConfig.keyType === "single_select") && !this.isValidJson(newConfig.config_select_json)) {
      this.toastr.error("Invalid JSON in select options. Please fix before saving.", "Error");
      return;
    }
    const extracttab = newConfig.tab.split("_");
    let config_value = newConfig.value;
    if (newConfig.keyType === "multiselect") {
      config_value = Array.isArray(config_value) ? config_value.join(",") : "";
    }
    if (newConfig.keyType === "single_select") {
      config_value = config_value != null ? config_value.toString() : "";
    }
    let config_select_json = newConfig.config_select_json;
    if (config_select_json === "" || config_select_json == null) {
      config_select_json = null;
    }
    this.insert_particular_schema.data["table1"] = [
      {
        order_no: 1,
        category_id: extracttab[0],
        config_key: newConfig.key,
        config_field_type: "text",
        config_value_type: "static",
        display_config: true,
        config_select_json: null,
        config_value,
        user_id: this.selectedUserId
      }
    ];
    if (this.selectedUserId) {
      let configSelectJson = this.newConfigForm.get("config_select_json")?.value;
      let parsedJson = {};
      try {
        parsedJson = configSelectJson ? JSON.parse(configSelectJson) : {};
      } catch (e) {
        parsedJson = {};
      }
      parsedJson.user_id = this.selectedUserId;
      this.newConfigForm.get("config_select_json")?.setValue(JSON.stringify(parsedJson));
    }
    this.gridApiService.executeRecords(this.insert_particular_schema).subscribe((response) => {
      if (response.status && response.code === 200) {
        const key = "record_updated_successfully";
        const successMessage = this.translate.instant(key);
        this.toastr.success(successMessage);
        this.newConfigForm.reset();
        this.toggleMenu();
        this.loadAllItems("act5");
      } else {
        const key = "record_failed_updated";
        const errorMessage = this.translate.instant(key);
        this.toastr.error(errorMessage, "Error");
      }
    }, (error) => {
      const key = "record_failed_inserted";
      const errorMessage = this.translate.instant(key);
      this.toastr.error(errorMessage, "Error");
    });
  }
  switchTab(tabName) {
    this.currentTab = tabName;
  }
  getInputType(fieldType) {
    switch (fieldType) {
      case "text":
      case "multiselect":
      case "single_select":
        return "text";
      case "number":
        return "number";
      case "date":
        return "date";
      case "checkbox":
        return "checkbox";
      case "file":
        return "file";
      case "time":
        return "time";
      default:
        return "text";
    }
  }
  onFieldTypeChange(tabName, index) {
    const configurationsArray = this.allTabsForm.get(tabName)?.get("configurations");
    const configControl = configurationsArray.at(index);
    const newFieldType = configControl.get("config_field_type")?.value;
  }
  // Helper to parse config_select_json for ng-select
  parseConfigSelectJson(jsonString) {
    if (!jsonString)
      return null;
    try {
      const parsed = typeof jsonString === "string" ? JSON.parse(jsonString) : jsonString;
      if (Array.isArray(parsed))
        return parsed;
      return null;
    } catch {
      return null;
    }
  }
  // Helper to validate config_select_json
  isValidJson(jsonString) {
    if (!jsonString)
      return true;
    try {
      const parsed = typeof jsonString === "string" ? JSON.parse(jsonString) : jsonString;
      return Array.isArray(parsed);
    } catch {
      return false;
    }
  }
  // Helper to get select options for a config FormGroup
  getSelectOptions(config) {
    return config._selectOptions;
  }
  openJsonEditor(index) {
    this.jsonEditorOpen[index] = true;
  }
  applyJson(index, config) {
    const jsonValue = config.get("config_select_json")?.value;
    try {
      const parsed = JSON.parse(jsonValue);
      config._selectOptions = Array.isArray(parsed) ? parsed : [];
      this.jsonEditorOpen[index] = false;
      this.cdr.detectChanges();
    } catch {
      this.toastr.error("Invalid JSON format", "Error");
    }
  }
  // For Add New Config modal
  applyJsonNew() {
    this.jsonEditorOpenNew = false;
    try {
      const jsonValue = this.newConfigForm.get("config_select_json")?.value;
      if (jsonValue) {
        JSON.parse(jsonValue);
      }
    } catch {
      this.toastr.error("Invalid JSON format", "Error");
    }
  }
  cancelJsonNew() {
    this.jsonEditorOpenNew = false;
  }
};
_UserConfigurationComponent.\u0275fac = function UserConfigurationComponent_Factory(t) {
  return new (t || _UserConfigurationComponent)(\u0275\u0275directiveInject(MenuMapService), \u0275\u0275directiveInject(ActivatedRoute), \u0275\u0275directiveInject(Store), \u0275\u0275directiveInject(GridApiService), \u0275\u0275directiveInject(LocalStorageService), \u0275\u0275directiveInject(FormBuilder), \u0275\u0275directiveInject(TranslateService), \u0275\u0275directiveInject(ToastrService), \u0275\u0275directiveInject(Router), \u0275\u0275directiveInject(Title), \u0275\u0275directiveInject(ChangeDetectorRef));
};
_UserConfigurationComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _UserConfigurationComponent, selectors: [["app-user-configuration"]], standalone: true, features: [\u0275\u0275StandaloneFeature], decls: 24, vars: 19, consts: [[1, "relative", 3, "ngSubmit", "formGroup"], [1, "mb-5"], [1, "header-panel", "mb-1", "mt-0", "flex", "flex-col", "gap-5", "px-2", "md:flex-row", "md:items-center"], ["appDynamicFontSize", "subtitle", 1, "py-1.5", "text-xs", "font-bold", "dark:text-white-light"], [1, "mt-3", "flex", "flex-wrap", "items-center", "justify-between", "border-b", "border-white-light", "dark:border-[#191e3a]"], [1, "flex"], ["href", "javascript:;", "class", "-mb-[1px] flex items-center border border-transparent p-3.5 py-2 outline-none transition duration-300 hover:text-danger", 3, "ngClass", "click", 4, "ngFor", "ngForOf"], [1, "mb-1", "mr-2", "rounded-md", "bg-gray-200", "px-4", "py-2", "text-black", "focus:outline-none", 3, "ngModelChange", "disabled", "ngModel", "ngModelOptions"], [3, "ngValue"], [3, "ngValue", 4, "ngFor", "ngForOf"], ["type", "button", 1, "mb-1", "mr-2", "rounded-md", "bg-blue-600", "px-4", "py-2", "text-white", "hover:bg-blue-700", "focus:outline-none", 3, "click"], [1, "fa-solid", "fa-plus"], ["type", "submit", 1, "mb-1", "rounded-md", "bg-orange-600", "px-4", "py-2", "text-white", "hover:bg-blue-700", "focus:outline-none"], [1, "flex-1", "pt-2", "text-sm"], [4, "ngFor", "ngForOf"], ["aria-labelledby", "options-menu", "aria-orientation", "vertical", "class", "advancedfiltercontainer absolute z-10 mt-2 origin-top-left divide-y divide-gray-100 rounded-md bg-white shadow-lg ring-1 ring-black ring-opacity-5", "role", "menu", 4, "ngIf"], ["href", "javascript:;", 1, "-mb-[1px]", "flex", "items-center", "border", "border-transparent", "p-3.5", "py-2", "outline-none", "transition", "duration-300", "hover:text-danger", 3, "click", "ngClass"], [3, "formGroupName", 4, "ngIf"], [3, "formGroupName"], ["formArrayName", "configurations"], [1, "table-hover", "relative", "min-w-full", "divide-y", "divide-gray-200", "dark:divide-gray-700"], [1, "bg-gray-50", "dark:bg-gray-800"], ["appDynamicFontSize", "body", 1, "w-36", "px-6", "py-3", "text-left", "font-bold", "tracking-wider", "dark:text-gray-300"], ["appDynamicFontSize", "body", 1, "w-[10%]", "px-6", "py-3", "text-left", "font-bold", "tracking-wider", "dark:text-gray-300"], [1, "divide-y", "divide-gray-200", "bg-white", "dark:divide-gray-700", "dark:bg-gray-900"], ["appDynamicFontSize", "body", 1, "whitespace-nowrap", "px-6", "py-4"], ["type", "text", "formControlName", "config_key", "appDynamicFontSize", "body", 1, "form-input", "mt-1", "block", "w-full", "rounded-md", "border-gray-300", "dark:border-gray-600", "dark:bg-gray-800", 3, "keydown", "ngClass"], [3, "ngSwitch"], [4, "ngSwitchCase"], ["type", "button", 1, "text-red-500", 3, "click"], [1, "fa-solid", "fa-xmark", "text-xl"], ["type", "text", "formControlName", "config_value", "appDynamicFontSize", "body", 1, "form-input", "mt-1", "block", "w-full", "rounded-md", "border-gray-300", "dark:border-gray-600", "dark:bg-gray-800"], ["type", "date", "formControlName", "config_value", "appDynamicFontSize", "body", 1, "form-input", "mt-1", "block", "w-full", "rounded-md", "border-gray-300", "dark:border-gray-600", "dark:bg-gray-800"], [2, "display", "flex", "align-items", "center", "gap", "0.5rem", "width", "100%"], ["class", "h-12 w-12 flex-shrink-0", 4, "ngIf"], ["type", "file", "appDynamicFontSize", "body", 1, "form-input", "mt-1", "block", "flex-1", "rounded-md", "border-gray-300", "dark:border-gray-600", "dark:bg-gray-800", 2, "flex", "1", 3, "change"], [1, "h-12", "w-12", "flex-shrink-0"], ["alt", "Loaded Image", 1, "h-full", "w-full", "bg-slate-200", "object-cover", 3, "src"], ["type", "number", "formControlName", "config_value", "appDynamicFontSize", "body", 1, "form-input", "mt-1", "block", "w-full", "rounded-md", "border-gray-300", "dark:border-gray-600", "dark:bg-gray-800"], ["type", "checkbox", "formControlName", "config_value", "appDynamicFontSize", "body", 1, "form-checkbox", "h-4", "w-4", "border-gray-300", "text-red-500", "dark:border-gray-600", "dark:bg-gray-800"], [2, "display", "flex", "align-items", "flex-start", "gap", "0.5rem", "min-height", "48px"], [4, "ngIf"], ["bindLabel", "name", "bindValue", "id", "formControlName", "config_value", "appDynamicFontSize", "body", 1, "custom-multiselect", 2, "width", "420px", "min-width", "420px", "max-width", "420px", 3, "items", "multiple"], ["type", "button", 2, "margin-left", "4px", "height", "38px", "width", "38px", "display", "flex", "align-items", "center", "justify-content", "center", 3, "click"], [1, "fa", "fa-code"], ["formControlName", "config_select_json", "rows", "4", "cols", "48", "placeholder", "Paste JSON here", 2, "min-width", "220px", "min-height", "38px", "resize", "vertical", "padding", "6px", "border-radius", "4px", "border", "1px solid #ccc", "font-family", "monospace"], ["type", "button", 2, "margin-left", "4px", "height", "38px", "width", "38px", "display", "flex", "align-items", "center", "justify-content", "center", "background", "#4caf50", "color", "white", "border", "none", "border-radius", "4px", 3, "click"], [1, "fa", "fa-check"], ["type", "button", 2, "margin-left", "2px", "height", "38px", "width", "38px", "display", "flex", "align-items", "center", "justify-content", "center", "background", "#f44336", "color", "white", "border", "none", "border-radius", "4px", 3, "click"], [1, "fa", "fa-times"], ["type", "time", "formControlName", "config_value", "appDynamicFontSize", "body", 1, "form-input", "mt-1", "block", "w-full", "rounded-md", "border-gray-300", "dark:border-gray-600", "dark:bg-gray-800"], ["bindLabel", "label", "bindValue", "name", "formControlName", "config_value", "placeholder", "Select Timezone", "appDynamicFontSize", "body", 1, "custom-multiselect", 3, "items", "searchable"], ["bindLabel", "label", "bindValue", "value", "formControlName", "config_value", "placeholder", "Select Datetime Format", "appDynamicFontSize", "body", 1, "custom-multiselect", 3, "items", "searchable"], ["aria-labelledby", "options-menu", "aria-orientation", "vertical", "role", "menu", 1, "advancedfiltercontainer", "absolute", "z-10", "mt-2", "origin-top-left", "divide-y", "divide-gray-100", "rounded-md", "bg-white", "shadow-lg", "ring-1", "ring-black", "ring-opacity-5"], [1, "flex", "items-center", "justify-between", "border-b", "border-gray-200", "p-4"], [1, "p-4", 3, "ngSubmit", "formGroup"], ["appearance", "compact", 1, "relative", "!h-[calc(40vh-40px)]"], [1, "mb-4"], ["for", "tabSelect", 1, "block", "text-sm", "font-medium", "text-gray-700"], ["id", "tabSelect", "formControlName", "tab", 1, "form-select", "mt-1", "block", "w-10/12", "rounded-md", "border-gray-300", "dark:border-gray-600", "dark:bg-gray-800"], [3, "value", 4, "ngFor", "ngForOf"], ["for", "key", 1, "block", "text-sm", "font-medium", "text-gray-700"], ["type", "text", "id", "key", "formControlName", "key", 1, "form-input", "mt-1", "block", "w-10/12", "rounded-md", "border-gray-300", "dark:border-gray-600", "dark:bg-gray-800", 3, "keydown"], ["for", "value", 1, "block", "text-sm", "font-medium", "text-gray-700"], ["type", "text", "id", "value", "formControlName", "value", 1, "form-input", "mt-1", "block", "w-10/12", "rounded-md", "border-gray-300", "dark:border-gray-600", "dark:bg-gray-800"], [1, "flex", "items-center", "justify-between", "border-t", "border-gray-200", "p-4"], [1, "flex", "gap-4"], ["type", "submit", 1, "btn-primary", "mx-auto", "flex", "items-center", "rounded-md", "border", "border-[#e0e6ed]", "px-4", "py-2", "font-semibold", "dark:border-[#253b5c]", "dark:bg-[#1b2e4b]", "dark:text-white-dark"], [1, "btn-secondary", "mx-auto", "flex", "items-center", "rounded-md", "border", "border-[#e0e6ed]", "px-4", "py-2", "font-semibold", "dark:border-[#253b5c]", "dark:bg-[#1b2e4b]", "dark:text-white-dark", 3, "click"], [3, "value"]], template: function UserConfigurationComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "form", 0);
    \u0275\u0275listener("ngSubmit", function UserConfigurationComponent_Template_form_ngSubmit_0_listener() {
      return ctx.saveChanges();
    });
    \u0275\u0275elementStart(1, "div", 1)(2, "div", 2)(3, "div", 3);
    \u0275\u0275text(4);
    \u0275\u0275pipe(5, "translate");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(6, "div", 4)(7, "div", 5);
    \u0275\u0275template(8, UserConfigurationComponent_a_8_Template, 2, 4, "a", 6);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(9, "div")(10, "select", 7);
    \u0275\u0275listener("ngModelChange", function UserConfigurationComponent_Template_select_ngModelChange_10_listener($event) {
      return ctx.onUserSelect($event);
    });
    \u0275\u0275elementStart(11, "option", 8);
    \u0275\u0275text(12, "Select User");
    \u0275\u0275elementEnd();
    \u0275\u0275template(13, UserConfigurationComponent_option_13_Template, 2, 2, "option", 9);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(14, "button", 10);
    \u0275\u0275listener("click", function UserConfigurationComponent_Template_button_click_14_listener() {
      return ctx.toggleMenu();
    });
    \u0275\u0275element(15, "i", 11);
    \u0275\u0275text(16);
    \u0275\u0275pipe(17, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(18, "button", 12);
    \u0275\u0275text(19);
    \u0275\u0275pipe(20, "translate");
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(21, "div", 13);
    \u0275\u0275template(22, UserConfigurationComponent_ng_container_22_Template, 2, 1, "ng-container", 14);
    \u0275\u0275elementEnd()()();
    \u0275\u0275template(23, UserConfigurationComponent_div_23_Template, 31, 20, "div", 15);
  }
  if (rf & 2) {
    \u0275\u0275property("formGroup", ctx.allTabsForm);
    \u0275\u0275advance(4);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(5, 12, ctx.title_key));
    \u0275\u0275advance(4);
    \u0275\u0275property("ngForOf", ctx.tabs);
    \u0275\u0275advance(2);
    \u0275\u0275property("disabled", ctx.disableuser)("ngModel", ctx.selectedUserId)("ngModelOptions", \u0275\u0275pureFunction0(18, _c0));
    \u0275\u0275advance();
    \u0275\u0275property("ngValue", null);
    \u0275\u0275advance(2);
    \u0275\u0275property("ngForOf", ctx.userList);
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate1(" \xA0", \u0275\u0275pipeBind1(17, 14, "form_button_add"), " ");
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(20, 16, "submit"), " ");
    \u0275\u0275advance(3);
    \u0275\u0275property("ngForOf", ctx.tabs);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx.isMenuOpen);
  }
}, dependencies: [CommonModule, NgClass, NgForOf, NgIf, NgSwitch, NgSwitchCase, FormsModule, \u0275NgNoValidate, NgSelectOption, \u0275NgSelectMultipleOption, DefaultValueAccessor, NumberValueAccessor, CheckboxControlValueAccessor, SelectControlValueAccessor, NgControlStatus, NgControlStatusGroup, NgModel, ReactiveFormsModule, FormGroupDirective, FormControlName, FormGroupName, FormArrayName, NgSelectModule, NgSelectComponent, CommonSharedModule, NgScrollbar, DynamicFontSizeDirective, TranslatePipe], styles: ["\n\n.advancedfiltercontainer[_ngcontent-%COMP%] {\n  min-width: 300px;\n  max-width: 100%;\n  width: 90%;\n  left: 50%;\n  transform: translateX(-50%);\n  right: auto;\n  z-index: 1000;\n  position: fixed;\n  top: 10%;\n  max-height: 60vh;\n  overflow-y: auto;\n}\ntable[_ngcontent-%COMP%]   thead[_ngcontent-%COMP%]   tr[_ngcontent-%COMP%]   th[_ngcontent-%COMP%], table[_ngcontent-%COMP%]   tfoot[_ngcontent-%COMP%]   tr[_ngcontent-%COMP%]   th[_ngcontent-%COMP%], table[_ngcontent-%COMP%]   tbody[_ngcontent-%COMP%]   tr[_ngcontent-%COMP%]   td[_ngcontent-%COMP%] {\n  padding-top: 0.35rem;\n  padding-bottom: 0.35rem;\n}\n@media (min-width: 640px) {\n  .advancedfiltercontainer[_ngcontent-%COMP%] {\n    min-width: 500px;\n    width: 60%;\n  }\n}\n@media (min-width: 1024px) {\n  .advancedfiltercontainer[_ngcontent-%COMP%] {\n    max-width: 600px;\n    width: 70%;\n  }\n}\n.advancedfiltercontainer[_ngcontent-%COMP%]   .relative[_ngcontent-%COMP%] {\n  max-height: calc(80vh - 120px);\n  overflow-y: auto;\n}\n@media (max-width: 640px) {\n  .advancedfiltercontainer[_ngcontent-%COMP%]   input[_ngcontent-%COMP%], .advancedfiltercontainer[_ngcontent-%COMP%]   select[_ngcontent-%COMP%] {\n    width: 100%;\n    margin-bottom: 0.5rem;\n  }\n  .advancedfiltercontainer[_ngcontent-%COMP%]   .flex[_ngcontent-%COMP%] {\n    flex-direction: column;\n  }\n  .advancedfiltercontainer[_ngcontent-%COMP%]   .flex[_ngcontent-%COMP%]    > *[_ngcontent-%COMP%] {\n    width: 100%;\n    margin-right: 0 !important;\n  }\n}\n.advancedfiltercontainer[_ngcontent-%COMP%]   .flex.items-center.justify-between[_ngcontent-%COMP%] {\n  flex-wrap: wrap;\n}\n.advancedfiltercontainer[_ngcontent-%COMP%]   .flex.items-center.justify-between[_ngcontent-%COMP%]    > *[_ngcontent-%COMP%] {\n  margin-bottom: 0.5rem;\n}\n.panel[_ngcontent-%COMP%] {\n  margin: -15px;\n  padding: 1.25rem 1.25rem 0.25rem 1.25rem;\n}\n.header-panel[_ngcontent-%COMP%] {\n  margin-top: -15px;\n}\n.panel[_ngcontent-%COMP%] {\n  padding: 1.25rem 1.25rem 0.25rem 1.25rem;\n}\n/*# sourceMappingURL=user-configuration.component.css.map */"] });
var UserConfigurationComponent = _UserConfigurationComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(UserConfigurationComponent, { className: "UserConfigurationComponent", filePath: "src\\app\\@lcp-framework\\pages\\user-configuration\\user-configuration.component.ts", lineNumber: 57 });
})();
export {
  UserConfigurationComponent
};
//# sourceMappingURL=chunk-6ZDYSREJ.js.map
