import {
  FormlyConfigModule
} from "./chunk-NFRJCL7R.js";
import {
  EditorComponent,
  MonacoEditorModule
} from "./chunk-62OL73TD.js";
import "./chunk-IGGXREIH.js";
import {
  LoaderComponent
} from "./chunk-X5XWBDVM.js";
import {
  MenuMapService
} from "./chunk-3FLJCSSF.js";
import {
  ToastrService
} from "./chunk-2YLAF7RI.js";
import {
  CommonSharedModule,
  DynamicFontSizeDirective,
  Store
} from "./chunk-7NQGM4EA.js";
import {
  DefaultValueAccessor,
  FormBuilder,
  FormControlName,
  FormGroupDirective,
  MaxLengthValidator,
  NgControlStatus,
  NgControlStatusGroup,
  NgModel,
  RadioControlValueAccessor,
  ReactiveFormsModule,
  RequiredValidator,
  TranslatePipe,
  TranslateService,
  Validators
} from "./chunk-NLYGDKUR.js";
import {
  animate,
  style,
  transition,
  trigger
} from "./chunk-ZEL7H2AL.js";
import {
  ActivatedRoute,
  GridApiService,
  LocalStorageService,
  Router
} from "./chunk-P7K2QEDI.js";
import {
  ChangeDetectorRef,
  CommonModule,
  DatePipe,
  Location,
  NgForOf,
  NgIf,
  Title,
  ɵsetClassDebugInfo,
  ɵɵProvidersFeature,
  ɵɵStandaloneFeature,
  ɵɵadvance,
  ɵɵdefineComponent,
  ɵɵdirectiveInject,
  ɵɵelement,
  ɵɵelementEnd,
  ɵɵelementStart,
  ɵɵgetCurrentView,
  ɵɵlistener,
  ɵɵloadQuery,
  ɵɵnextContext,
  ɵɵpipe,
  ɵɵpipeBind1,
  ɵɵproperty,
  ɵɵqueryRefresh,
  ɵɵresetView,
  ɵɵrestoreView,
  ɵɵtemplate,
  ɵɵtext,
  ɵɵtextInterpolate,
  ɵɵtextInterpolate1,
  ɵɵtwoWayBindingSet,
  ɵɵtwoWayListener,
  ɵɵtwoWayProperty,
  ɵɵviewQuery
} from "./chunk-GKZIWABI.js";
import {
  __async,
  __spreadProps,
  __spreadValues
} from "./chunk-CVWHNZRK.js";

// src/app/@lcp-framework/pages/policy/policy.component.ts
var _c0 = ["monacoEditor"];
function PolicyComponent_div_20_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 35);
    \u0275\u0275text(1);
    \u0275\u0275pipe(2, "translate");
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(2, 1, "policy_name_is_required"), " ");
  }
}
function PolicyComponent_div_21_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 35);
    \u0275\u0275text(1, " Policy name cannot exceed 75 characters. ");
    \u0275\u0275elementEnd();
  }
}
function PolicyComponent_div_27_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 35);
    \u0275\u0275text(1);
    \u0275\u0275pipe(2, "translate");
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(2, 1, "policy_description_is_required"), " ");
  }
}
function PolicyComponent_div_43_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 35);
    \u0275\u0275text(1);
    \u0275\u0275pipe(2, "translate");
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(2, 1, "status_is_required"), " ");
  }
}
function PolicyComponent_div_46_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 10)(1, "label", 36);
    \u0275\u0275text(2);
    \u0275\u0275pipe(3, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275element(4, "input", 37);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(3, 1, "slug"));
  }
}
function PolicyComponent_div_59_li_17_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "li")(1, "div", 58)(2, "span", 59);
    \u0275\u0275text(3);
    \u0275\u0275pipe(4, "translate");
    \u0275\u0275elementEnd()()();
  }
  if (rf & 2) {
    const item_r3 = ctx.$implicit;
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(4, 1, item_r3));
  }
}
function PolicyComponent_div_59_p_19_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "p", 60);
    \u0275\u0275text(1, "Copied to clipboard!");
    \u0275\u0275elementEnd();
  }
}
function PolicyComponent_div_59_Template(rf, ctx) {
  if (rf & 1) {
    const _r1 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 38);
    \u0275\u0275element(1, "div", 39);
    \u0275\u0275elementStart(2, "div", 40)(3, "div", 41)(4, "div", 42)(5, "div", 43)(6, "div", 44)(7, "p", 45);
    \u0275\u0275text(8);
    \u0275\u0275pipe(9, "translate");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(10, "button", 46);
    \u0275\u0275listener("click", function PolicyComponent_div_59_Template_button_click_10_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.closeInfoPopUp());
    });
    \u0275\u0275elementStart(11, "span", 47);
    \u0275\u0275text(12, "Close");
    \u0275\u0275elementEnd();
    \u0275\u0275element(13, "i", 48);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(14, "div", 49)(15, "div", 50)(16, "ul", 51);
    \u0275\u0275template(17, PolicyComponent_div_59_li_17_Template, 5, 3, "li", 52);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(18, "div", 53);
    \u0275\u0275template(19, PolicyComponent_div_59_p_19_Template, 2, 0, "p", 54);
    \u0275\u0275elementStart(20, "div", 55)(21, "ngx-monaco-editor", 56);
    \u0275\u0275listener("click", function PolicyComponent_div_59_Template_ngx_monaco_editor_click_21_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.copyToClipboard());
    });
    \u0275\u0275twoWayListener("ngModelChange", function PolicyComponent_div_59_Template_ngx_monaco_editor_ngModelChange_21_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      \u0275\u0275twoWayBindingSet(ctx_r1.popupInformation.data, $event) || (ctx_r1.popupInformation.data = $event);
      return \u0275\u0275resetView($event);
    });
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(22, "div", 57);
    \u0275\u0275listener("click", function PolicyComponent_div_59_Template_div_click_22_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.copyToClipboard());
    });
    \u0275\u0275elementEnd()()()()()()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275advance(8);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(9, 5, ctx_r1.popupInformation.header));
    \u0275\u0275advance(9);
    \u0275\u0275property("ngForOf", ctx_r1.popupInformation.comments);
    \u0275\u0275advance(2);
    \u0275\u0275property("ngIf", ctx_r1.copied);
    \u0275\u0275advance(2);
    \u0275\u0275property("options", ctx_r1.popupInfoEditorOptions);
    \u0275\u0275twoWayProperty("ngModel", ctx_r1.popupInformation.data);
  }
}
function PolicyComponent_app_loader_60_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "app-loader");
  }
}
var _PolicyComponent = class _PolicyComponent {
  constructor(fb, router, route, toastr, gridApiService, translate, commonService, localStorageService, titleService, storeData, location, datePipe, cdr) {
    this.fb = fb;
    this.router = router;
    this.route = route;
    this.toastr = toastr;
    this.gridApiService = gridApiService;
    this.translate = translate;
    this.commonService = commonService;
    this.localStorageService = localStorageService;
    this.titleService = titleService;
    this.storeData = storeData;
    this.location = location;
    this.datePipe = datePipe;
    this.cdr = cdr;
    this.loading = false;
    this.title = "";
    this.editorOptions = { theme: "vs-dark", language: "sql", tabSize: 1, insertSpaces: true };
    this.htmlEditorOptions = __spreadProps(__spreadValues({}, this.editorOptions), { language: "html" });
    this.isDarkTheme = true;
    this.isInfoModalOpen = false;
    this.infoContents = {
      queryInfo: {
        header: "Sample Policy Information",
        comments: [],
        data: {
          sort_columns: [["users.id", "desc"]],
          search_all: [
            {
              column_name: "users.deleted_at",
              value: null,
              operator: "IS"
            }
          ],
          search_any: [
            {
              column_name: "users.deleted_at",
              value: null,
              operator: "IS"
            }
          ],
          includes: [
            {
              table_name: "user_details",
              join_type: "INNER",
              join_condition: "users.id = user_details.user_id"
            }
          ],
          group_by: ["users.id", "user_details.first_name", "user_details.last_name"],
          having_conditions: [
            {
              column_name: "users.deleted_at",
              value: null,
              operator: "IS"
            }
          ],
          having_any_conditions: [
            {
              value: "%Mukesh%",
              operator: "ILIKE",
              column_name: "concat(user_details.first_name, ' ', user_details.last_name)"
            }
          ]
        }
      }
    };
    this.popupInformation = null;
    this.popupInfoEditorOptions = __spreadProps(__spreadValues({}, this.editorOptions), { language: "sql", cursorStyle: "line", readOnly: true, automaticLayout: true, minimap: { enabled: false } });
    this.copied = false;
    this.route.paramMap.subscribe((params) => {
      this.unique_id = params.get("id");
    });
    this.userData = JSON.parse(this.localStorageService.getData("user_data"))?.main || {};
    this.policyForm = this.fb.group({
      policy_id: [""],
      policy_name: ["", [Validators.required, Validators.maxLength(75)]],
      policy_description: ["", [Validators.required]],
      slug: [{ value: "", disabled: true }],
      query_information: [""],
      status_id: [1]
    });
    if (this.unique_id) {
      this.getPolicyData();
    }
  }
  ngOnInit() {
    this.initStore();
    this.resetComponent();
    const pageInfo = this.route.snapshot.data["pageInfo"] || "";
    if (pageInfo) {
      const translateTitle = this.translate.instant(pageInfo.fullEntity);
      this.titleService.setTitle(translateTitle);
      this.title = pageInfo.fullEntity;
    } else {
      this.title = "Default Title";
    }
  }
  ngOnDestroy() {
  }
  initStore() {
    return __async(this, null, function* () {
      this.storeData.select((d) => d.index).subscribe((d) => {
        this.store = d;
      });
    });
  }
  resetComponent() {
    this.policyForm.patchValue({
      policy_id: "",
      policy_name: "",
      policy_description: "",
      slug: "",
      query_information: "",
      status_id: 1
    });
  }
  prepareJSON(data) {
    return JSON.stringify(JSON.parse(data));
  }
  prettyJSON(data) {
    return JSON.stringify(JSON.parse(JSON.stringify(data).replace(/@table(\w+)/g, "##table$1")), null, 2);
  }
  getPolicyData() {
    if (this.unique_id) {
      const payload = {
        group_by: ["policies.id"],
        includes: [],
        company_id: 1,
        search_all: [
          {
            value: this.unique_id,
            operator: "=",
            column_name: "policies.uuid"
          },
          {
            value: "3",
            operator: "!=",
            column_name: "policies.status_id"
          }
        ],
        limit_range: 1,
        print_query: true,
        start_index: 0,
        sort_columns: [["policies.id", "asc"]],
        primary_table: "policies",
        select_columns: [
          ["policies.id", "policy_id"],
          ["policies.name", "policy_name"],
          ["policies.slug", "slug"],
          ["policies.description", "policy_description"],
          ["policies.status_id", "status_id"],
          ["policies.query_information", "query_information"]
        ]
      };
      this.loading = true;
      this.commonService.getCommonList(payload).subscribe({
        next: (response) => {
          if (response.code === 200 && response.status) {
            this.loading = false;
            if (response.data.records) {
              const data = response.data.records[0];
              this.policyForm.patchValue({
                policy_id: data.policy_id,
                policy_name: data.policy_name,
                policy_description: data.policy_description,
                query_information: data?.query_information ? this.prettyJSON(data.query_information) : "",
                slug: data.slug,
                status_id: data.status_id
              });
            } else {
              const key = "failed_to_fetch_the_policy_details";
              const errorMessage = this.translate.instant(key);
              this.toastr.error(errorMessage, "Error");
            }
          } else {
            this.loading = false;
          }
        },
        error: (error) => {
          this.loading = false;
          console.error("Error fetching URL details:", error);
        }
      });
    } else {
      this.loading = false;
      const key = "invalid_policy";
      const errorMessage = this.translate.instant(key);
      this.toastr.error(errorMessage, "Error");
    }
  }
  generateSlug(data) {
    return this.localStorageService.generateSlugWithTimestamp(data.policy_name);
  }
  upsertPolicy() {
    const policyData = this.policyForm.getRawValue();
    const policyPayload = __spreadProps(__spreadValues({
      name: policyData.policy_name?.trim(),
      description: policyData.policy_description?.length ? policyData.policy_description : null,
      slug: this.unique_id ? policyData.slug : this.generateSlug(policyData),
      query_information: policyData?.query_information ? this.prepareJSON(policyData.query_information) : null,
      status_id: Number(policyData.status_id) || 1
    }, !this.unique_id && {
      created_at: true,
      created_by: true
    }), {
      updated_by: true,
      updated_at: true
    });
    const payload = {
      data: {
        table1: [policyPayload]
      },
      table: ["policies"],
      action: [...this.unique_id ? ["update"] : ["insert"]],
      table_mapping: ["table1"],
      conditions: __spreadValues({}, this.unique_id && {
        table1: [
          {
            uuid: this.unique_id,
            status_id: {
              operator: "!=",
              value: 3
            }
          }
        ]
      })
    };
    this.loading = true;
    this.gridApiService.executeRecords(payload).subscribe({
      next: (response) => {
        this.loading = false;
        if (response.code === 200 && response.status) {
          const key = !this.unique_id ? "policy_created_successfully" : "policy_updated_successfully";
          const successMessage = this.translate.instant(key);
          this.toastr.success(successMessage);
          if (!this.unique_id) {
            this.location.back();
            return;
          }
          this.resetComponent();
          this.getPolicyData();
        } else {
          const key = !this.unique_id ? "failed_to_create_the_policy" : "failed_to_update_the_policy";
          const errorMessage = this.translate.instant(key);
          this.toastr.error(errorMessage, "Error");
        }
      },
      error: (error) => {
        this.loading = false;
        console.error("Error fetching URL details:", error);
        const key = "record_failed_inserted";
        const errorMessage = this.translate.instant(key);
        this.toastr.error(errorMessage, "Error");
      }
    });
  }
  openInfoPopUp(popup) {
    this.isInfoModalOpen = true;
    this.popupInformation = __spreadProps(__spreadValues({}, this.infoContents[popup]), {
      data: JSON.stringify(this.infoContents[popup].data, null, 2)
    });
  }
  closeInfoPopUp() {
    this.isInfoModalOpen = false;
    this.popupInformation = null;
  }
  // Copy content from Monaco Editor
  copyToClipboard() {
    navigator.clipboard.writeText(this.popupInformation.data).then(() => {
      this.copied = true;
      setTimeout(() => this.copied = false, 3e3);
    }).catch((err) => console.error("Failed to copy:", err));
  }
};
_PolicyComponent.\u0275fac = function PolicyComponent_Factory(t) {
  return new (t || _PolicyComponent)(\u0275\u0275directiveInject(FormBuilder), \u0275\u0275directiveInject(Router), \u0275\u0275directiveInject(ActivatedRoute), \u0275\u0275directiveInject(ToastrService), \u0275\u0275directiveInject(GridApiService), \u0275\u0275directiveInject(TranslateService), \u0275\u0275directiveInject(MenuMapService), \u0275\u0275directiveInject(LocalStorageService), \u0275\u0275directiveInject(Title), \u0275\u0275directiveInject(Store), \u0275\u0275directiveInject(Location), \u0275\u0275directiveInject(DatePipe), \u0275\u0275directiveInject(ChangeDetectorRef));
};
_PolicyComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _PolicyComponent, selectors: [["app-policy"]], viewQuery: function PolicyComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c0, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.monacoEditor = _t.first);
  }
}, standalone: true, features: [\u0275\u0275ProvidersFeature([DatePipe]), \u0275\u0275StandaloneFeature], decls: 61, vars: 38, consts: [[3, "formGroup"], [1, "panel"], [1, "mb-5", "flex", "flex-col", "items-start", "justify-between", "gap-3", "lg:flex-row", "lg:items-center"], [1, "text-lg", "font-semibold", "dark:text-white-light"], ["appDynamicFontSize", "body", "type", "button", 1, "btn", "btn-danger", "mr-5", "ltr:rounded-r", "rtl:rounded-l", 3, "click"], [1, "w-full", "space-y-5", "dark:text-white"], [1, "rounded-md", "p-2", "md:col-span-2", "lg:col-span-3"], [1, "space-y-5"], [1, "grid", "grid-cols-1", "gap-6", "lg:grid-cols-1"], [1, "mb-5", "grid", "grid-cols-1", "gap-6", "lg:grid-cols-3"], [1, "flex", "flex-col"], ["for", "policy_name", 1, "required-mark", "mb-2", "block", "font-medium"], ["autocomplete", "off", "appDynamicFontSize", "body", "formControlName", "policy_name", "id", "policy_name", "type", "text", "maxlength", "75", 1, "form-input", "w-full", "py-1", "text-xs", "text-gray-600", "placeholder:text-white-dark", 3, "required"], ["class", "invalid-feedback mt-1 text-danger", 4, "ngIf"], ["for", "policy_description", 1, "required-mark", "mb-2", "block", "font-medium"], ["autocomplete", "off", "appDynamicFontSize", "body", "formControlName", "policy_description", "id", "policy_description", "type", "text", 1, "form-input", "w-full", "py-1", "text-xs", "text-gray-600", "placeholder:text-white-dark", 3, "required"], [1, "required-mark", "mb-2", "block", "font-medium"], [1, "flex", "items-center", "space-x-4"], ["for", "1", 1, "flex", "cursor-pointer", "items-center"], ["id", "1", "type", "radio", "formControlName", "status_id", "appDynamicFontSize", "body", 1, "form-radio", 3, "value"], [1, "ml-2", "text-white-dark"], ["for", "2", 1, "flex", "cursor-pointer", "items-center"], ["id", "2", "type", "radio", "formControlName", "status_id", "appDynamicFontSize", "body", 1, "form-radio", 3, "value"], ["class", "flex flex-col", 4, "ngIf"], [1, "grid", "grid-cols-1"], [1, "mb-5", "p-2"], [1, "flex", "flex-row", "gap-3"], ["for", "queryInformation", 1, "mb-2", "block", "font-medium"], [1, "fas", "fa-circle-info", "fa-lg", "cursor-pointer", "!leading-none", 3, "click"], ["appDynamicFontSize", "body", 1, "monaco-editor-container"], ["monacoEditor", "", "id", "query_information", "formControlName", "query_information", 1, "monaco-editor", 3, "options"], [1, "flex", "flex-row", "justify-end", "gap-4", "py-4"], ["type", "button", 1, "hover:bg-primary-dark", "dark:bg-primary-dark", "dark:focus:ring-primary-dark", "flex", "w-40", "flex-row", "items-center", "justify-center", "gap-8", "rounded-md", "bg-primary", "px-6", "py-2", "text-white", "shadow-sm", "focus:outline-none", "focus:ring-2", "focus:ring-primary", "focus:ring-offset-2", "dark:text-white", 3, "click", "disabled"], ["class", "fixed inset-0 z-50 overflow-y-auto", 4, "ngIf"], [4, "ngIf"], [1, "invalid-feedback", "mt-1", "text-danger"], ["for", "slug"], ["autocomplete", "off", "appDynamicFontSize", "body", "formControlName", "slug", "id", "slug", "type", "text", "readonly", "", 1, "form-input", "w-full", "py-1", "text-xs", "text-gray-600", "placeholder:text-white-dark"], [1, "fixed", "inset-0", "z-50", "overflow-y-auto"], [1, "fixed", "inset-0", "bg-black/50", "transition-opacity", "dark:bg-black/70"], [1, "flex", "min-h-screen", "items-center", "justify-center", "p-2", "sm:p-4"], [1, "max-w-auto", "relative", "w-10/12", "transform", "overflow-hidden", "rounded-lg", "bg-white", "shadow-xl", "transition-all", "dark:border", "dark:border-gray-700", "dark:bg-gray-800", "sm:w-8/12"], [1, "border-b", "bg-gray-50", "px-4", "py-3", "dark:border-gray-700", "dark:bg-gray-900", "sm:px-6"], [1, "flex", "items-center", "justify-between"], [1, "flex", "gap-4"], ["appDynamicFontSize", "body", 1, "text-md", "font-bold"], [1, "close-btn", 3, "click"], [1, "sr-only"], [1, "fa-solid", "fa-xmark"], [1, "max-h-auto", "gap-5", "overflow-y-auto", "px-4", "py-4", "sm:px-6"], [1, "px-4", "sm:px-6"], [1, "flex", "list-disc", "flex-col", "gap-3"], [4, "ngFor", "ngForOf"], [1, "relative"], ["class", "absolute right-5 top-3 z-50 rounded bg-green-700 px-3 py-1 text-sm text-white hover:bg-green-600", 4, "ngIf"], [1, "monaco-editor-container", ".editor-container", "mt-3", "rounded", "border", "border-gray-300"], ["monacoEditor", "", "id", "popupInformation", 1, "monaco-editor", 3, "click", "ngModelChange", "options", "ngModel"], [1, "editor-overlay", 3, "click"], [1, "flex", "items-center", "gap-2"], ["appDynamicFontSize", "body", 1, "text-sm"], [1, "absolute", "right-5", "top-3", "z-50", "rounded", "bg-green-700", "px-3", "py-1", "text-sm", "text-white", "hover:bg-green-600"]], template: function PolicyComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 0)(1, "div", 1)(2, "div", 2)(3, "h5", 3);
    \u0275\u0275text(4);
    \u0275\u0275pipe(5, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(6, "button", 4);
    \u0275\u0275listener("click", function PolicyComponent_Template_button_click_6_listener() {
      return ctx.location.back();
    });
    \u0275\u0275text(7);
    \u0275\u0275pipe(8, "translate");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(9, "div", 5)(10, "div", 6)(11, "div", 7)(12, "div")(13, "div", 8)(14, "div", 9)(15, "div", 10)(16, "label", 11);
    \u0275\u0275text(17);
    \u0275\u0275pipe(18, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275element(19, "input", 12);
    \u0275\u0275template(20, PolicyComponent_div_20_Template, 3, 3, "div", 13)(21, PolicyComponent_div_21_Template, 2, 0, "div", 13);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(22, "div", 10)(23, "label", 14);
    \u0275\u0275text(24);
    \u0275\u0275pipe(25, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275element(26, "input", 15);
    \u0275\u0275template(27, PolicyComponent_div_27_Template, 3, 3, "div", 13);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(28, "div", 10)(29, "label", 16);
    \u0275\u0275text(30);
    \u0275\u0275pipe(31, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(32, "div", 17)(33, "label", 18);
    \u0275\u0275element(34, "input", 19);
    \u0275\u0275elementStart(35, "span", 20);
    \u0275\u0275text(36);
    \u0275\u0275pipe(37, "translate");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(38, "label", 21);
    \u0275\u0275element(39, "input", 22);
    \u0275\u0275elementStart(40, "span", 20);
    \u0275\u0275text(41);
    \u0275\u0275pipe(42, "translate");
    \u0275\u0275elementEnd()()();
    \u0275\u0275template(43, PolicyComponent_div_43_Template, 3, 3, "div", 13);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(44, "div", 8)(45, "div", 9);
    \u0275\u0275template(46, PolicyComponent_div_46_Template, 5, 3, "div", 23);
    \u0275\u0275elementEnd()()()()()();
    \u0275\u0275elementStart(47, "div", 24)(48, "div", 25)(49, "div", 26)(50, "label", 27);
    \u0275\u0275text(51);
    \u0275\u0275pipe(52, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(53, "i", 28);
    \u0275\u0275listener("click", function PolicyComponent_Template_i_click_53_listener() {
      return ctx.openInfoPopUp("queryInfo");
    });
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(54, "div", 29);
    \u0275\u0275element(55, "ngx-monaco-editor", 30);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(56, "div", 31)(57, "button", 32);
    \u0275\u0275listener("click", function PolicyComponent_Template_button_click_57_listener() {
      return ctx.upsertPolicy();
    });
    \u0275\u0275text(58, " Submit ");
    \u0275\u0275elementEnd()()()();
    \u0275\u0275template(59, PolicyComponent_div_59_Template, 23, 7, "div", 33)(60, PolicyComponent_app_loader_60_Template, 1, 0, "app-loader", 34);
  }
  if (rf & 2) {
    let tmp_5_0;
    let tmp_6_0;
    let tmp_9_0;
    let tmp_15_0;
    \u0275\u0275property("formGroup", ctx.policyForm);
    \u0275\u0275advance(4);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(5, 22, "policy_add_edit_form"), " ");
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(8, 24, "back"), " ");
    \u0275\u0275advance(10);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(18, 26, "policy_name"));
    \u0275\u0275advance(2);
    \u0275\u0275property("required", true);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ((tmp_5_0 = ctx.policyForm.get("policy_name")) == null ? null : tmp_5_0.invalid) && (((tmp_5_0 = ctx.policyForm.get("policy_name")) == null ? null : tmp_5_0.touched) || ((tmp_5_0 = ctx.policyForm.get("policy_name")) == null ? null : tmp_5_0.dirty)));
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", (tmp_6_0 = ctx.policyForm.get("policy_name")) == null ? null : tmp_6_0.errors == null ? null : tmp_6_0.errors["maxlength"]);
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(25, 28, "policy_description"));
    \u0275\u0275advance(2);
    \u0275\u0275property("required", true);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ((tmp_9_0 = ctx.policyForm.get("policy_description")) == null ? null : tmp_9_0.invalid) && (((tmp_9_0 = ctx.policyForm.get("policy_description")) == null ? null : tmp_9_0.touched) || ((tmp_9_0 = ctx.policyForm.get("policy_description")) == null ? null : tmp_9_0.dirty)));
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(31, 30, "form_label_status"));
    \u0275\u0275advance(4);
    \u0275\u0275property("value", 1);
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(37, 32, "table_status_val_0"));
    \u0275\u0275advance(3);
    \u0275\u0275property("value", 2);
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(42, 34, "table_status_val_1"));
    \u0275\u0275advance(2);
    \u0275\u0275property("ngIf", ((tmp_15_0 = ctx.policyForm.get("status_id")) == null ? null : tmp_15_0.invalid) && (((tmp_15_0 = ctx.policyForm.get("status_id")) == null ? null : tmp_15_0.touched) || ((tmp_15_0 = ctx.policyForm.get("status_id")) == null ? null : tmp_15_0.dirty)));
    \u0275\u0275advance(3);
    \u0275\u0275property("ngIf", ctx.unique_id);
    \u0275\u0275advance(5);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(52, 36, "form_label_query_information"));
    \u0275\u0275advance(4);
    \u0275\u0275property("options", ctx.editorOptions);
    \u0275\u0275advance(2);
    \u0275\u0275property("disabled", ctx.policyForm.invalid ? true : false);
    \u0275\u0275advance(2);
    \u0275\u0275property("ngIf", ctx.isInfoModalOpen);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx.loading);
  }
}, dependencies: [CommonSharedModule, NgForOf, NgIf, DefaultValueAccessor, RadioControlValueAccessor, NgControlStatus, NgControlStatusGroup, RequiredValidator, MaxLengthValidator, NgModel, DynamicFontSizeDirective, TranslatePipe, MonacoEditorModule, EditorComponent, ReactiveFormsModule, FormGroupDirective, FormControlName, LoaderComponent, FormlyConfigModule, CommonModule], styles: ["\n\n.monaco-editor-container[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  height: 50vh;\n  resize: vertical;\n  min-height: 60vh;\n  max-height: 100vh;\n}\n.monaco-editor[_ngcontent-%COMP%] {\n  flex: 1;\n  width: 100%;\n}\n.editor-container[_ngcontent-%COMP%] {\n  position: relative;\n}\n.editor-overlay[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  width: 100%;\n  height: 100%;\n  overflow: auto;\n  cursor: pointer !important;\n  background: transparent;\n  pointer-events: none;\n}\n.monaco-editor[_ngcontent-%COMP%] {\n  cursor: pointer !important;\n}\n.monaco-editor[_ngcontent-%COMP%]   .view-line[_ngcontent-%COMP%] {\n  cursor: pointer !important;\n}\n/*# sourceMappingURL=policy.component.css.map */"], data: { animation: [
  trigger("toggleAnimation", [
    transition(":enter", [style({ opacity: 0, transform: "scale(0.95)" }), animate("100ms ease-out", style({ opacity: 1, transform: "scale(1)" }))]),
    transition(":leave", [animate("75ms", style({ opacity: 0, transform: "scale(0.95)" }))])
  ])
] } });
var PolicyComponent = _PolicyComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(PolicyComponent, { className: "PolicyComponent", filePath: "src\\app\\@lcp-framework\\pages\\policy\\policy.component.ts", lineNumber: 33 });
})();
export {
  PolicyComponent
};
//# sourceMappingURL=chunk-EPT3QTKW.js.map
