import {
  CryptoHttpService,
  LocalStorageService,
  commonConfig,
  environment
} from "./chunk-P7K2QEDI.js";
import {
  HttpClient,
  HttpHeaders,
  Subject,
  ɵɵdefineInjectable,
  ɵɵinject
} from "./chunk-GKZIWABI.js";

// src/app/@lcp-framework/service/common/auth.service.ts
var _AuthService = class _AuthService {
  constructor(http, localstore, cryptoHttp) {
    this.http = http;
    this.localstore = localstore;
    this.cryptoHttp = cryptoHttp;
  }
  login(credentials) {
    return this.http.post(`${environment.apiUrl}${environment.apiAddress}${commonConfig.API.login}`, credentials);
  }
  logout() {
    const authToken = this.localstore.getData("user_data") && JSON.parse(this.localstore.getData("user_data")).main.token;
    const headers = new HttpHeaders({
      Authorization: "Bearer " + authToken,
      Accept: "application/json"
    });
    return this.http.get(`${environment.apiUrl}${environment.apiAddress}${commonConfig.API.logout}`, { headers });
  }
  languageList(data) {
    return this.http.post(`${environment.apiUrl}${environment.apiAddress}${commonConfig.API.getLanguageContent}`, data);
  }
  generatePowerBiEmbedToken(data) {
    return this.http.get(`${environment.apiUrl}${environment.apiAddress}${commonConfig.API.generatePowerBiEmbedToken}?reportId=${data.reportId}&groupId=${data.groupId}`);
  }
};
_AuthService.\u0275fac = function AuthService_Factory(t) {
  return new (t || _AuthService)(\u0275\u0275inject(HttpClient), \u0275\u0275inject(LocalStorageService), \u0275\u0275inject(CryptoHttpService));
};
_AuthService.\u0275prov = /* @__PURE__ */ \u0275\u0275defineInjectable({ token: _AuthService, factory: _AuthService.\u0275fac, providedIn: "root" });
var AuthService = _AuthService;

// src/app/@lcp-framework/service/common/language.service.ts
var _LanguageService = class _LanguageService {
  constructor(authservice, localstore, http) {
    this.authservice = authservice;
    this.localstore = localstore;
    this.http = http;
    this.languageDataUpdated = new Subject();
  }
  getLanguageIdFromCode(code) {
    switch (code) {
      case "en":
        return 1;
      case "ae":
        return 2;
      default:
        return 1;
    }
  }
  getLanguageId(code) {
    return this.getLanguageIdFromCode(code);
  }
  serviceChangeLanguage(companyId, languageCode) {
    const languageId = this.getLanguageId(languageCode);
    this.fetchLanguageData(companyId, languageId);
    this.localstore.storeData("languageCode", languageCode);
    if (!this.localstore.getData("languageReload")) {
      this.localstore.storeData("languageReload", "true");
      setTimeout(() => {
        window.location.reload();
      }, 1500);
    }
  }
  fetchLanguageData(companyId, languageId) {
    const payload = { company_id: companyId, language_id: languageId };
    this.authservice.languageList(payload).subscribe({
      next: (response) => {
        if (response.code === 200 && response.status) {
          this.localstore.removeData("lang_contents");
          const lang_contents = response.data;
          this.localstore.storeData("lang_contents", JSON.stringify(lang_contents));
          this.languageDataUpdated.next(lang_contents);
        }
      },
      error: (error) => {
        console.error("Error fetching language data:", error);
      }
    });
  }
  getLanguageDataUpdates() {
    return this.languageDataUpdated.asObservable();
  }
  checkReloadFlag() {
    const languageReload = this.localstore.getData("languageReload");
    if (languageReload === "true") {
      this.localstore.removeData("languageReload");
      return true;
    }
    return false;
  }
  getSavedLanguageCode() {
    return this.localstore.getData("languageReload") || "en";
  }
};
_LanguageService.\u0275fac = function LanguageService_Factory(t) {
  return new (t || _LanguageService)(\u0275\u0275inject(AuthService), \u0275\u0275inject(LocalStorageService), \u0275\u0275inject(HttpClient));
};
_LanguageService.\u0275prov = /* @__PURE__ */ \u0275\u0275defineInjectable({ token: _LanguageService, factory: _LanguageService.\u0275fac, providedIn: "root" });
var LanguageService = _LanguageService;

export {
  AuthService,
  LanguageService
};
//# sourceMappingURL=chunk-RWHSBLZT.js.map
