"use strict";
/**
 * @openapi
 * /openai/generate-schema-chunks:
 *   get:
 *     tags:
 *       - OpenAI
 *     summary: Generate and store schema chunks for all database tables
 *     description: This endpoint generates embeddings for all table schemas and stores them for query generation
 *     security:
 *       - AccessToken: []
 *     responses:
 *       200:
 *         description: Schema chunks generated successfully
 *         content:
 *           application/json:
 *             schema:
 *               type: object
 *               properties:
 *                 success:
 *                   type: boolean
 *                   example: true
 *                 message:
 *                   type: string
 *                   example: Schema chunks generated and stored successfully
 *       401:
 *         description: Unauthorized - Invalid or missing token
 *       500:
 *         description: Internal server error
 */
/**
 * @openapi
 * /openai/generate-query:
 *   post:
 *     tags:
 *       - OpenAI
 *     summary: Generate SQL query from natural language prompt
 *     description: Converts a natural language prompt into a SQL query using OpenAI's capabilities
 *     security:
 *       - AccessToken: []
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           schema:
 *             type: object
 *             required:
 *               - prompt
 *             properties:
 *               prompt:
 *                 type: string
 *                 description: Natural language description of the desired query
 *                 example: Get all users who registered in the last month
 *     responses:
 *       200:
 *         description: Query generated successfully
 *         content:
 *           application/json:
 *             schema:
 *               type: object
 *               properties:
 *                 success:
 *                   type: boolean
 *                   example: true
 *                 data:
 *                   type: object
 *                   properties:
 *                     query:
 *                       type: string
 *                       example: SELECT * FROM users WHERE created_at >= NOW() - INTERVAL '1 month'
 *                     explanation:
 *                       type: string
 *                       example: This query retrieves all users who registered within the last month
 *       400:
 *         description: Bad request - Missing or invalid prompt
 *         content:
 *           application/json:
 *             schema:
 *               type: object
 *               properties:
 *                 success:
 *                   type: boolean
 *                   example: false
 *                 message:
 *                   type: string
 *                   example: Prompt is required
 *       401:
 *         description: Unauthorized - Invalid or missing token
 *       500:
 *         description: Internal server error
 */
/**
 * @openapi
 * /openai/get-response-from-sql:
 *   post:
 *     tags:
 *       - OpenAI
 *     summary: Get response from SQL query
 *     description: Get response from SQL query using OpenAI's capabilities
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           schema:
 *             type: object
 *             required:
 *               - sql
 *             properties:
 *               sql:
 *                 type: string
 *                 description: SQL query to execute
 *                 example: SELECT * FROM users WHERE created_at >= NOW() - INTERVAL '1 month'
 *     responses:
 *       200:
 *         description: OK
 *     security:
 *       - AccessToken: []
 */
/**
 * @openapi
 * /openai/generate-vector:
 *   get:
 *     tags:
 *       - OpenAI
 *     summary: Generate vector for schema chunks
 *     description: Generate vector for schema chunks using OpenAI's capabilities
 *     security:
 *       - AccessToken: []
 *     responses:
 *       200:
 *         description: Vector generated and stored successfully
 */
/**
 * @openapi
 * /openai/generate-vector-for-table:
 *   post:
 *     tags:
 *       - OpenAI
 *     summary: Generate vector for a specific table
 *     description: Generate vector for a specific table using OpenAI's capabilities
 *     security:
 *       - AccessToken: []
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           schema:
 *             type: object
 *             required:
 *               - uuid
 *             properties:
 *               uuid:
 *                 type: string
 *                 description: UUID of the table to generate vector for
 *                 example: 123e4567-e89b-12d3-a456-426614174000
 *     responses:
 *       200:
 *         description: Vector generated and stored successfully
 */ 
