import { PrismaClient } from '@prisma/pg/client';

const prisma = new PrismaClient();

let activityTypes: any = [{
      "id": 1,
      "name": "Development",
      "description": "Writing, reviewing, or refactoring code",
      "company_id": 1,
      "status_id": 1
    },
    {
      "id": 2,
      "name": "Testing",
      "description": "Manual or automated testing",
      "company_id": 1,
      "status_id": 1
    },
    {
      "id": 3,
      "name": "Code Review",
      "description": "Reviewing peer code or pull requests",
      "company_id": 1,
      "status_id": 1
    },
    {
      "id": 4,
      "name": "Documentation",
      "description": "Writing technical documentation or wikis",
      "company_id": 1,
      "status_id": 1
    },
    {
      "id": 5,
      "name": "Design",
      "description": "Designing system, architecture, or UI/UX",
      "company_id": 1,
      "status_id": 1
    },
    {
      "id": 6,
      "name": "Meeting",
      "description": "Attending standups, sprint planning, retros",
      "company_id": 1,
      "status_id": 1
    },
    {
      "id": 7,
      "name": "Research",
      "description": "Investigating tools, bugs, or exploring tech",
      "company_id": 1,
      "status_id": 1
    },
    {
      "id": 8,
      "name": "Deployment",
      "description": "Releasing builds or managing CI/CD pipelines",
      "company_id": 1,
      "status_id": 1
    },
    {
      "id": 9,
      "name": "Bug Fixing",
      "description": "Resolving defects or issues",
      "company_id": 1,
      "status_id": 1
    },
    {
      "id": 10,
      "name": "Task Management",
      "description": "Grooming backlog, estimating, ticket updates",
      "company_id": 1,
      "status_id": 1
    },
    {
      "id": 11,
      "name": "Admin Work",
      "description": "Non-project admin work, emails, follow-ups",
      "company_id": 1,
      "status_id": 1
    },
    {
      "id": 12,
      "name": "Learning",
      "description": "Training or internal knowledge sharing",
      "company_id": 1,
      "status_id": 1
    },
    {
      "id": 13,
      "name": "Support",
      "description": "Providing support or resolving customer issues",
      "company_id": 1,
      "status_id": 1
    }
  ];

export async function activitySeeder(company_id: number) {

  // replace company id
  activityTypes.forEach((each: any) => {
      each.company_id = company_id;
  });

  for(let each of activityTypes) {
    const acitivitydata = await prisma.activityType.findUnique({
      where: {
        id: each.id
      },
    });

    if(acitivitydata) {
      await prisma.activityType.update({
        where: {
          id: each.id
        },
        data: { 
          name: each.name, 
          company_id: each.company_id, 
          status_id: each.status_id 
        }
      });
      console.log('Activity type with id ',each.id,' is updated');
    } else {
      await prisma.activityType.create({
        data: {
          id: each.id, 
          name: each.name, 
          company_id: each.company_id, 
          status_id: each.status_id 
        }
      });
       console.log('Activity type with id ',each.id,' is created');
    }
  }
}