import { PrismaClient, Prisma } from '@prisma/pg/client';
import { v4 as uuidv4 } from 'uuid';

const prisma = new PrismaClient();

export async function languageSeeds(companyId: number) {

    try {
        let user = await prisma.user.findFirst({
            where: {company_id:companyId, role: 'super_admin'}
        });
        if(!user){
            console.log(`Menu seeder failed: admin user not available for company id ${companyId}`);
            return false;
        }

        const createdBy = user.id;
        const langList: any[] = [];

        const company = await prisma.user.findFirst({
            where: { company_id: companyId }
        });

        if (!company) {
            console.log(`WARNING: languageSeeds: Company with id ${companyId} does not exist.`);
            return;
        }

        for (const { name, code, status } of langList) {

            const existingRecord = await prisma.language.findFirst({
                where: {
                    name: name,
                    company_id: companyId,
                }
            });

            if (existingRecord) {
                console.log(`Language "${name}" already inserted for company_id ${companyId}`);
            } else {
           
                await prisma.language.create({
                    data: {
                        uuid: uuidv4(),
                        name,
                        name_in_english:name,
                        code,
                        description:name,
                        status_id:status,
                        company_id: companyId,
                        created_by: createdBy
                    }
                });
                console.log(`Created new language: name ${name}, company_id ${companyId}`);
            }
            
        }
    } catch (error) {
        console.error(`Error in languageSeeds: ${error}`);
        if (error instanceof Prisma.PrismaClientKnownRequestError && error.code === 'P2003' && error.meta) {
            console.error(`Foreign key constraint failed: ${error.meta.field_name}`);
        }
        throw error;
    } finally {
        // await prisma.$disconnect();
    }

}
