CREATE OR REPLACE VIEW last_week_data AS
WITH last_week AS (
    SELECT id, year, is_current_year, TO_CHAR(start_date, 'DD-MM-YYYY') AS start_date, TO_CHAR(end_date, 'DD-MM-YYYY') AS end_date, month, week_number, status_id, company_id
    FROM yearly_week 
    WHERE is_current_year = true AND EXTRACT(WEEK FROM start_date) = EXTRACT(WEEK FROM CURRENT_DATE - interval '1 week') -- This gets the past week
    ORDER BY start_date DESC 
    LIMIT 1
)
SELECT *
FROM last_week;

