CREATE OR REPLACE VIEW user_timesheet_summary AS
SELECT 
    u.id AS user_id,
    u.reporting_to as reporting_to,
    COUNT(CASE WHEN ts.is_saved = false THEN 1 END) AS not_submitted,
    COUNT(CASE WHEN ts.is_saved = true THEN 1 END) AS saved,
    COUNT(CASE WHEN ts.is_saved IS NULL THEN 1 END) AS not_created
FROM 
    users u
CROSS JOIN 
    yearly_week yw
LEFT JOIN 
    time_sheet ts 
    ON ts.week_id = yw.id 
    AND ts.user_id = u.id
GROUP BY 
    u.id
ORDER BY 
    u.id;