import { PrismaClient, UserRole } from '@prisma/pg/client';
import { v4 as uuidv4 } from 'uuid';
import bcrypt from 'bcryptjs';
const prisma = new PrismaClient();

function getCurrentUtcTime() {
  return new Date().toISOString();
}

const SUPER_ADMIN_SECRET = process.env.JWT_SECRET || 'secret';

async function initPassword(
  plainPassword: string,
  role: string,
): Promise<string> {
  if (role === 'super_admin') {
    // Add a checksum or secret key to the password before hashing
    const combinedPassword = `${plainPassword}:${SUPER_ADMIN_SECRET}`;
    const salt = await bcrypt.genSalt(12); // More rounds for super_admin
    return await bcrypt.hash(combinedPassword, salt);
  } else {
    // Regular user password hashing
    return await bcrypt.hash(plainPassword, 10);
  }
}

const sAdmins = [
  {
    email: 'karthickn+1@techcedence.com',
    username: 'Karthick N Super Admin',
    password: 'SAdmin@123#',
    role: 'super_admin',

    code: '1000',
    first_name: 'Karthick',
    last_name: 'SA',
    id:1,
  },
  {
    email: 'praveenk+1@techcedence.com',
    username: 'Praveen K Company Admin',
    password: 'Test@123',
    role: 'company_admin',

    code: '1001',
    first_name: 'Praveen',
    last_name: 'CA',
    id:2501,
  }
];

export async function usersSeeder(company_id: number) {
  try {
    const utcNow = getCurrentUtcTime();

    for (const admin of sAdmins) {
      let user = await prisma.user.findUnique({
        where: {
          company_id_username: { company_id, username: admin.username },
        },
      });

      if (user) {
        user = await prisma.user.update({
          where: { id: user.id },
          data: {
            email: admin.email,
            username: admin.username,
            password: await initPassword(admin.password, admin.role),
            role: admin.role as UserRole,
            updated_by: user.id,
            updated_at: utcNow,
          },
        });
        console.log(`User updated successfully: ${user.username}`);
      } else {
        user = await prisma.user.create({
          data: {
            id:admin.id,
            uuid: uuidv4(),
            email: admin.email,
            username: admin.username,
            password: await initPassword(admin.password, admin.role),
            role: admin.role as UserRole,
            company_id,
            created_at: utcNow,
            updated_at: utcNow,
          },
        });

        await prisma.userDetail.create({
          data: {
            id:admin.id,
            user_id: user.id,
            code: admin.code,
            first_name: admin.first_name,
            last_name: admin.last_name,
            company_id,
            created_by: user.id,
            updated_by: user.id,
            created_at: utcNow,
            updated_at: utcNow,
          },
        });
        console.log(`User created successfully: ${user.username}`);
      }
    }
  } catch (error) {
    console.log(`User seeder failed`);
    throw error;
  } finally {
    // await prisma.$disconnect();
  }
}
