import { PrismaClient } from '@prisma/pg/client';
import { v4 as uuidv4 } from 'uuid';

const prisma = new PrismaClient();

const datas = [
  {
    slug: 'mtr-mail-import',
    name: 'MTR Mail Import',
    subject: 'Details Imported by  [user_fullname], [mtr_reference_number]',
    template_body:
      '<p>Hi, [user_email] - [user_fullname] data has been imported and attached the details in the below file</p><p></p>',
    email_template_process_slug: 'mtr-mail-import',
    status_id: 1,
  },
  {
    slug: 'mir-mail-import',
    name: 'MIR Mail Import',
    subject: 'Details Imported by  [user_fullname], [mir_reference_number]',
    template_body:
      '<p>Hi, [user_email] - [user_fullname] data has been imported and attached the details in the below file</p><p></p>',
    email_template_process_slug: 'mir-mail-import',
    status_id: 1,
  },
];

export async function appEmailTemplatesSeeder(company_id: number) {
  try {
    let user = await prisma.user.findFirst({
      where: { company_id: company_id, role: 'super_admin' },
    });
    if (!user) {
      console.log(
        `Menu seeder failed: admin user not available for company id ${company_id}`,
      );
      return false;
    }

    const created_by = user.id;

    const company = await prisma.user.findFirst({
      where: { company_id: company_id },
    });

    if (!company) {
      console.log(`WARNING: Company with id ${company_id} does not exist.`);
      return;
    }

    for (const data of datas) {
      const emailTemplateProcess = await prisma.emailTemplateProcess.findFirst({
        where: {
          slug: data.email_template_process_slug,
          company_id: company_id,
        },
      });

      if (!emailTemplateProcess) {
        console.log(
          `Email Template Process with slug "${data.email_template_process_slug}" not found for company_id ${company_id}. Skipping template creation.`,
        );
        continue;
      }

      const existingTemplate = await prisma.emailTemplate.findFirst({
        where: {
          slug: data.slug,
          company_id: company_id,
        },
      });

      if (!existingTemplate) {
        try {
          await prisma.emailTemplate.create({
            data: {
              uuid: uuidv4(),
              slug: data.slug,
              name: data.name,
              subject: data.subject,
              template_body: data.template_body,
              email_template_process_id: emailTemplateProcess.id,
              status_id: data.status_id,
              company_id: company_id,
              created_by: created_by,
            },
          });
          console.log(
            `Created new Email Template: ${data.name} for company_id ${company_id}`,
          );
        } catch (createError) {
          console.error(
            `Error creating email template with slug "${data.slug}":`,
            createError,
          );
        }
      } else {
        console.log(
          `Email Template with slug "${data.slug}" already exists for company_id ${company_id}.`,
        );
      }
    }
  } catch (error) {
    console.error(`Error in seedEmailTemplates: ${error}`);
    throw error;
  } finally {
    // await prisma.$disconnect();
  }
}
