import { PrismaClient, Prisma } from '@prisma/sql/client';

const prisma = new PrismaClient();

export async function menuTypesSeeds(companyId: number) {
  const types = ['Web', 'Mobile', 'Web and Mobile'];

  try {
    console.log("🚀 Starting Menu Types Seeder...");

    let company = await prisma.user.findFirst({
      where: {
        company_id: companyId,
      },
    });

    if (!company) {
      console.log(`❌ WARNING: Company with id ${companyId} does not exist.`);
      return;
    }

    for (const type of types) {
      let existingType = await prisma.menuType.findFirst({
        where: {
          name: type,
          company_id: companyId,
        },
      });

      if (existingType) {
        console.log(`🔄 Updated menu type for company ${companyId}, type ${type} already exists.`);
      } else {
        await prisma.menuType.create({
          data: {
            name: type,
            company_id: companyId,
          },
        });

        console.log(`✅ Created new menu type for company ${companyId}, type ${type}`);
      }
    }

    console.log("✅ Menu Types Seeder completed successfully.");
  } catch (error) {
    console.error(`❌ Error in menuTypesSeeds: ${error}`);
    if (error instanceof Prisma.PrismaClientKnownRequestError && error.code === 'P2003' && error.meta) {
      console.error(`Foreign key constraint failed: ${error.meta.field_name}`);
    }
    throw error;
  } finally {
    await prisma.$disconnect();
  }
}
