"use strict";var __awaiter=this&&this.__awaiter||function(e,t,a,s){return new(a||(a=Promise))((function(i,o){function d(e){try{l(s.next(e))}catch(e){o(e)}}function c(e){try{l(s.throw(e))}catch(e){o(e)}}function l(e){var t;e.done?i(e.value):(t=e.value,t instanceof a?t:new a((function(e){e(t)}))).then(d,c)}l((s=s.apply(e,t||[])).next())}))},__importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0});const supertest_1=__importDefault(require("supertest")),__1=require("../../");let token="";const params={login:{admin:!0,email:"mithilesh@gmail.com",password:"SAdmin@123#",remember_me:!0},noDevice:{deviceIds:[]},deviceCreate:{deviceIds:["100","101"]},duplicateDevice:{deviceIds:["100","101"]},removeDuplicate:{deviceIds:["102","102"]},someDuplicates:{deviceIds:["102","103","104","105"]},allDeviceAllocated:{deviceIds:[1],companyId:1},someDeviceAllocated:{deviceIds:[1,2,3],companyId:1},noDeviceAllocated:{deviceIds:[1,2],companyId:1},emptyDeviceIds:{deviceIds:[],companyId:1},allocationLimitExceeded:{deviceIds:[1,2,3,4,5],companyId:1},allDeviceUnAllocated:{deviceIds:[3]},unallocateSomeUnallocated:{deviceIds:[3,2]},unallocateAllUnallocated:{deviceIds:[3,2]},defectiveDevice:{deviceIds:[4,5]},getAll:{status:"unallocated"},deviceMetricsAll:"null"};beforeAll((()=>__awaiter(void 0,void 0,void 0,(function*(){try{const e=yield(0,supertest_1.default)(__1.app).post("/api/common/auth/login").send(params.login);token=e.body&&e.body.result&&e.body.result.token?e.body.result.token:""}catch(e){console.error("Error during setup:",e)}})))),describe("POST /api/admin/device/create",(()=>{it("should return status 500 if no device ids provided",(()=>__awaiter(void 0,void 0,void 0,(function*(){const e=yield(0,supertest_1.default)(__1.app).post("/api/admin/device/create").set("Authorization",`Bearer ${token}`).send(params.noDevice);expect(e.status).toBe(500),expect(e.body).toEqual({code:500,message:"Enter atleast one device id",status:!1})})))),it("should return status 200 with devices created successfully",(()=>__awaiter(void 0,void 0,void 0,(function*(){const e=yield(0,supertest_1.default)(__1.app).post("/api/admin/device/create").set("Authorization",`Bearer ${token}`).send(params.deviceCreate);expect(e.status).toBe(200),expect(e.body).toEqual({code:200,message:"Devices created successfully",status:!0})})))),it("should return status 500 if all device ids are duplicate",(()=>__awaiter(void 0,void 0,void 0,(function*(){const e=yield(0,supertest_1.default)(__1.app).post("/api/admin/device/create").set("Authorization",`Bearer ${token}`).send(params.duplicateDevice);expect(e.status).toBe(500),expect(e.body).toEqual({code:500,message:"Enter atleast one non duplicate device id",status:!1})})))),it("should return status 200 and create devices if there are non-duplicate device ids",(()=>__awaiter(void 0,void 0,void 0,(function*(){const e=yield(0,supertest_1.default)(__1.app).post("/api/admin/device/create").set("Authorization",`Bearer ${token}`).send(params.removeDuplicate);expect(e.status).toBe(200),expect(e.body).toEqual({code:200,message:"Devices created successfully",status:!0})})))),it("should return status 200 with message about excluded duplicate ids if some duplicates were found",(()=>__awaiter(void 0,void 0,void 0,(function*(){const e=yield(0,supertest_1.default)(__1.app).post("/api/admin/device/create").set("Authorization",`Bearer ${token}`).send(params.someDuplicates);expect(e.status).toBe(200),expect(e.body.code).toEqual(200),expect(e.body.status).toBe(!0),expect(e.body.message).toEqual("Some duplicate device id's were found and excluded"),expect(e.body).toHaveProperty("result.duplicateIds"),expect(Array.isArray(e.body.result.duplicateIds)).toBe(!0)}))))})),describe("POST /api/admin/device/getAll",(()=>{it("should return a list of items with status 200",(()=>__awaiter(void 0,void 0,void 0,(function*(){const e=yield(0,supertest_1.default)(__1.app).post("/api/admin/device/getAll").set("Authorization",`Bearer ${token}`).send(params.getAll);expect(e.status).toBe(200),expect(e.body).toHaveProperty("result.list"),expect(e.body).toHaveProperty("result.count"),expect(Array.isArray(e.body.result.list)).toBe(!0)}))))})),describe("GET /api/admin/device/metrics/:companyId",(()=>{it("should get device metrices to all companies with status 200",(()=>__awaiter(void 0,void 0,void 0,(function*(){const e=yield(0,supertest_1.default)(__1.app).get(`/api/admin/device/metrics/${params.deviceMetricsAll}`).set("Authorization",`Bearer ${token}`);expect(e.status).toBe(200),expect(e.body).toHaveProperty("result.allocated"),expect(e.body).toHaveProperty("result.unallocated"),expect(e.body).toHaveProperty("result.defective")}))))})),describe("POST /api/admin/device/allocateDevice",(()=>{it("should post All devices were allocated successfully with status 200",(()=>__awaiter(void 0,void 0,void 0,(function*(){const e=yield(0,supertest_1.default)(__1.app).post("/api/admin/device/allocateDevice").set("Authorization",`Bearer ${token}`).send(params.allDeviceAllocated);expect(e.status).toBe(200),expect(e.body).toEqual({code:200,message:"All devices were allocated successfully",status:!0})})))),it("should post Some allocated devices invalidDeviceIds were present and excluded with status 200",(()=>__awaiter(void 0,void 0,void 0,(function*(){const e=yield(0,supertest_1.default)(__1.app).post("/api/admin/device/allocateDevice").set("Authorization",`Bearer ${token}`).send(params.someDeviceAllocated);expect(e.status).toBe(200),expect(e.body.code).toEqual(200),expect(e.body.status).toBe(!0),expect(e.body.message).toEqual("Some allocated devices were present and excluded")})))),it("should post All device ids were already allocated with status 500",(()=>__awaiter(void 0,void 0,void 0,(function*(){const e=yield(0,supertest_1.default)(__1.app).post("/api/admin/device/allocateDevice").set("Authorization",`Bearer ${token}`).send(params.noDeviceAllocated);expect(e.status).toBe(500),expect(e.body).toEqual({code:500,message:"All device ids were already allocated",status:!1})})))),it("should post No device ids were sent with status 500",(()=>__awaiter(void 0,void 0,void 0,(function*(){const e=yield(0,supertest_1.default)(__1.app).post("/api/admin/device/allocateDevice").set("Authorization",`Bearer ${token}`).send(params.emptyDeviceIds);expect(e.status).toBe(500),expect(e.body).toEqual({code:500,message:"No device ids were sent",status:!1})})))),it("should post Unable to allocate more than the limit provided by super admin with status 500",(()=>__awaiter(void 0,void 0,void 0,(function*(){const e=yield(0,supertest_1.default)(__1.app).post("/api/admin/device/allocateDevice").set("Authorization",`Bearer ${token}`).send(params.allocationLimitExceeded);expect(e.status).toBe(500),expect(e.body).toEqual({code:500,message:"Unable to allocate more than the limit provided by super admin",status:!1})}))))})),describe("POST /api/admin/device/unAllocateDevice",(()=>{it("should post All devices were unallocated successfully with status 200",(()=>__awaiter(void 0,void 0,void 0,(function*(){const e=yield(0,supertest_1.default)(__1.app).post("/api/admin/device/unAllocateDevice").set("Authorization",`Bearer ${token}`).send(params.allDeviceUnAllocated);expect(e.status).toBe(200),expect(e.body).toEqual({code:200,message:"All devices were unallocated successfully",status:!0})})))),it("should post Some unallocated devices were present and excluded",(()=>__awaiter(void 0,void 0,void 0,(function*(){const e=yield(0,supertest_1.default)(__1.app).post("/api/admin/device/unAllocateDevice").set("Authorization",`Bearer ${token}`).send(params.unallocateSomeUnallocated);expect(e.status).toBe(200),expect(e.body).toEqual({code:200,message:"Some unallocated devices were present and excluded",status:!0})})))),it("should post No device ids were already allocated",(()=>__awaiter(void 0,void 0,void 0,(function*(){const e=yield(0,supertest_1.default)(__1.app).post("/api/admin/device/unAllocateDevice").set("Authorization",`Bearer ${token}`).send(params.unallocateSomeUnallocated);expect(e.status).toBe(500),expect(e.body).toEqual({code:500,message:"No device ids were already allocated",status:!1})})))),it("should post No device ids were sent",(()=>__awaiter(void 0,void 0,void 0,(function*(){const e=yield(0,supertest_1.default)(__1.app).post("/api/admin/device/unAllocateDevice").set("Authorization",`Bearer ${token}`).send(params.noDevice);expect(e.status).toBe(500),expect(e.body).toEqual({code:500,message:"No device ids were sent",status:!1})}))))})),describe("POST /api/admin/device/defectDevice",(()=>{it("should post All devices were marked as defective successfully with status 200",(()=>__awaiter(void 0,void 0,void 0,(function*(){const e=yield(0,supertest_1.default)(__1.app).post("/api/admin/device/defectDevice").set("Authorization",`Bearer ${token}`).send(params.defectiveDevice);expect(e.status).toBe(200),expect(e.body).toEqual({code:200,message:"All devices were marked as defective successfully",status:!0})})))),it("should post No device ids were sent",(()=>__awaiter(void 0,void 0,void 0,(function*(){const e=yield(0,supertest_1.default)(__1.app).post("/api/admin/device/defectDevice").set("Authorization",`Bearer ${token}`).send(params.noDevice);expect(e.status).toBe(500),expect(e.body).toEqual({code:500,message:"No device ids were sent",status:!1})}))))}));