import { ScheduledJob, PrismaClient } from '@prisma/pg/client';

const prisma = new PrismaClient();

export async function scheduledJobSeeder() {
  try {
    const scheduledJobArr = [
      {
        id: 1,
        cron_url: 'cron/process-email-jobs',
        timing: '10,30,50 * * * * *',
        concat_base_url: true,
        description:
          'A scheduled task that processes pending email jobs, sending emails and updating their status accordingly.',
      },
      {
        id: 2,
        cron_url: 'cron/send-notification-jobs',
        timing: '20,40,59 * * * * *',
        concat_base_url: true,
        description:
          'Sends queued email or whatsapp jobs such as notifications, alerts, or newsletters.',
      },
      {
        id: 3,
        cron_url: 'cron/schedule-import-job',
        timing: '0 1 * * *',
        concat_base_url: true,
        description:
          'Schedules and triggers data import jobs from external sources or files.',
      },
      {
        id: 4,
        cron_url: 'cron/truncate-request-logs',
        timing: '0 0 */3 * *',
        concat_base_url: true,
        description:
          'Periodically clears old entries from the request logs to maintain database performance.',
      }, // every 3 days at midnight
      {
        id: 5,
        cron_url: 'cron/truncate-audit-logs',
        timing: '0 0 */3 * *',
        concat_base_url: true,
        description:
          'Periodically clears old entries from the audit logs to manage storage and keep audit data current.',
      }, // every 3 days at midnight
      {
        id: 6,
        cron_url: 'cron/process-whatsapp-jobs',
        timing: '10,30,50 * * * * *',
        concat_base_url: true,
        description:
          'A scheduled task that processes pending email jobs, sending emails and updating their status accordingly.',
      },
    ];

    for (const scheduledJob of scheduledJobArr) {
      await findOrCreateScheduledJob(scheduledJob);
    }

    console.log('ScheduledJob creation completed.');
  } catch (error) {
    throw error;
  }
}

async function findOrCreateScheduledJob(scheduledJob: any) {
  try {
    let resData: ScheduledJob | undefined | null;

    resData = await prisma.scheduledJob.findUnique({
      where: { id: scheduledJob.id },
    });

    if (!resData) {
      let data = {
        ...scheduledJob,
      };

      resData = await prisma.scheduledJob.create({
        data,
      });
      console.log(
        `ScheduledJob created successfully: ${scheduledJob.cron_url}`,
      );
    } else {
      let data = {
        ...scheduledJob,
      };

      resData = await prisma.scheduledJob.update({
        where: { id: resData.id },
        data,
      });
      console.log(`ScheduledJob updated successfully: ${resData.cron_url}`);
    }

    return resData;
  } catch (error) {
    console.log(`ScheduledJob seeder failed: ${scheduledJob.cron_url}`);
    throw error;
  } finally {
    // await prisma.$disconnect();
  }
}
