CREATE OR REPLACE FUNCTION enforce_uppercase()
RETURNS TRIGGER AS $$
BEGIN
    NEW.name := UPPER(NEW.name);  -- Convert to uppercase before storing
    RETURN NEW;
END;
$$ LANGUAGE plpgsql;


CREATE TRIGGER item_actions_uppercase_trigger
BEFORE INSERT OR UPDATE ON item_actions
FOR EACH ROW
EXECUTE FUNCTION enforce_uppercase();


CREATE OR REPLACE FUNCTION enforce_uppercase_item_condition()
RETURNS TRIGGER AS $$
BEGIN
    NEW.name := UPPER(NEW.name);
    RETURN NEW;
END;
$$ LANGUAGE plpgsql;



CREATE TRIGGER item_conditions_uppercase_trigger
BEFORE INSERT OR UPDATE ON item_conditions
FOR EACH ROW
EXECUTE FUNCTION enforce_uppercase_item_condition();