CREATE OR REPLACE FUNCTION public.get_grid_columns(var_entity_name text, var_company_id integer)
 RETURNS jsonb
 LANGUAGE plpgsql
AS $function$
DECLARE
    select_columns JSONB := '[]';
    field RECORD;
BEGIN
    FOR field IN
        SELECT mgl.field_name, mgl.display_name,
	    mgl.order_no, is_searchable, is_grid_column, mgl.is_sortable, mgl.field_name, mgl.field_type_id, mgl.clause_type, mgl.link_type,
            mgl.link_action,mgl.link_mode
        FROM master_entities mg
        JOIN master_entity_line_items mgl ON mg.id = mgl.master_grid_id
        WHERE mg.entity_name = var_entity_name AND mg.company_id = var_company_id AND mgl.status_id = 1 AND (mgl.is_grid_column = true OR mgl.display_name IN ('id','uuid','downloadables') OR mgl.display_name LIKE 'gparam_%')
		ORDER BY mgl.order_no ASC
    LOOP
        select_columns := select_columns || jsonb_build_array(
			jsonb_build_array(
				field.field_name, field.display_name, field.order_no, field.is_searchable,
				field.is_grid_column, field.is_sortable, field.field_name, field.field_type_id,
                field.clause_type, field.link_type,
                field.link_action,field.link_mode
			)
		);
    END LOOP;
    RETURN select_columns;
END;
$function$