DROP FUNCTION IF EXISTS public.get_email_template(INT);
CREATE OR REPLACE FUNCTION public.get_email_template(p_template_id INT)
RETURNS JSONB
LANGUAGE plpgsql
AS $function$
DECLARE
    result JSONB;
BEGIN
    SELECT 
	    jsonb_build_object(
	        'email_template', to_jsonb(et),
	        'email_template_process', to_jsonb(etp)
	    ) INTO result
	FROM email_templates et
	INNER JOIN email_template_process etp 
	    ON etp.id = et.email_template_process_id
	WHERE et.id = p_template_id;

    RETURN result;
EXCEPTION
    WHEN OTHERS THEN
        RAISE EXCEPTION 'Unexpected error in get_email_template: %', SQLERRM;
END;
$function$;
