#!/bin/bash

echo "🚀 Starting database seed process..."

# Default to development if no argument is passed
ENVIRONMENT=${1:-development}
ENVIRONMENT=$(echo "$ENVIRONMENT" | xargs)

ENV_FILE=".env.${ENVIRONMENT}"

if [ ! -f "$ENV_FILE" ]; then
  echo "❌ Environment file '$ENV_FILE' not found!"
  exit 1
fi

echo "✅ Using environment file: $ENV_FILE"

# Load env file so npm scripts can access NODE_ENV or other vars if needed
set -a
source "$ENV_FILE"
set +a

echo "🌱 Running app seed script for NODE_ENV=$ENVIRONMENT"

case "$ENVIRONMENT" in
  development)
    npm run dev:app-seed:pg
    ;;
  staging)
    npm run stag:app-seed:pg
    ;;
  production)
    npm run prod:app-seed:pg
    ;;
  *)
    echo "❌ Unknown NODE_ENV: $ENVIRONMENT"
    exit 1
    ;;
esac

if [ $? -ne 0 ]; then
  echo "❌ Seed script failed."
  exit 1
fi

echo "✅ Database app seed process completed."
